% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_delete_knowledge_base_documents}
\alias{bedrockagent_delete_knowledge_base_documents}
\title{Deletes documents from a data source and syncs the changes to the
knowledge base that is connected to it}
\usage{
bedrockagent_delete_knowledge_base_documents(
  clientToken = NULL,
  dataSourceId,
  documentIdentifiers,
  knowledgeBaseId
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than one time. If this token matches a previous
request, Amazon Bedrock ignores the request, but does not return an
error. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{dataSourceId}{[required] The unique identifier of the data source that contains the documents.}

\item{documentIdentifiers}{[required] A list of objects, each of which contains information to identify a
document to delete.}

\item{knowledgeBaseId}{[required] The unique identifier of the knowledge base that is connected to the
data source.}
}
\description{
Deletes documents from a data source and syncs the changes to the knowledge base that is connected to it. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/kb-direct-ingestion.html}{Ingest changes directly into a knowledge base} in the Amazon Bedrock User Guide.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_delete_knowledge_base_documents/} for full documentation.
}
\keyword{internal}
