% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_delete_logging_configuration}
\alias{wafv2_delete_logging_configuration}
\title{Deletes the LoggingConfiguration from the specified web ACL}
\usage{
wafv2_delete_logging_configuration(
  ResourceArn,
  LogType = NULL,
  LogScope = NULL
)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the web ACL from which you want to
delete the LoggingConfiguration.}

\item{LogType}{Used to distinguish between various logging options. Currently, there is
one option.

Default: \code{WAF_LOGS}}

\item{LogScope}{The owner of the logging configuration, which must be set to \code{CUSTOMER}
for the configurations that you manage.

The log scope \code{SECURITY_LAKE} indicates a configuration that is managed
through Amazon Security Lake. You can use Security Lake to collect log
and event data from various sources for normalization, analysis, and
management. For information, see \href{https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html}{Collecting data from Amazon Web Services services}
in the \emph{Amazon Security Lake user guide}.

Default: \code{CUSTOMER}}
}
\description{
Deletes the LoggingConfiguration from the specified web ACL.

See \url{https://www.paws-r-sdk.com/docs/wafv2_delete_logging_configuration/} for full documentation.
}
\keyword{internal}
