% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{Q.Amc_oneway}
\alias{Q.Amc_oneway}
\title{PB multiple comparisons of factor A in one-way ANOVA}
\usage{
Q.Amc_oneway(L,ns, means, s2, alpha)
}
\arguments{
\item{L}{Number of simulated values for the distribution}

\item{ns}{sample size for each group}

\item{means}{sample mean for each group}

\item{s2}{sample variance for each group}

\item{alpha}{significant level}
}
\value{
the simulated p-value

D.crit: The (1 - alpha) percentile of the simulated distribution

res.df: The differences, confidence intervals for the difference, and p-values for comparisons of each
two factor levels.
}
\description{
Using Parametric Bootstrap to simulate a distribution for multiple comparison in one-way ANOVA
}
\examples{

library(pbANOVA)

data(fedata)

fedata$depth <- factor(fedata$depth)

library(Rmisc)
summarySE(fedata, "Y", "depth")

feNs <- summarySE(fedata, "Y", "depth")$N
feYs <- summarySE(fedata, "Y", "depth")$Y
fes2 <- (summarySE(fedata, "Y", "depth")$sd)^2

anova(lm(Y~depth, data=fedata))  #F-test significant
#we saw in the dunnett's example that the equal variance assumption is violated

library(MASS) #need MASS for ginv function for all the interaction and main effects algorithms
alg.A1(ns=feNs, ybars=feYs, s2=fes2, a=6, L=5000)
#p=0.0038

#multiple comparisons
Q.Amc_oneway(L = 5000, ns=feNs, means=feYs, s2=fes2, alpha = 0.05)

#compare to Tukey's test
TukeyHSD(aov(Y~depth, data=fedata))

#results agree only for some levels.


}
