% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{rel.vert.tri}
\alias{rel.vert.tri}
\title{The index of the vertex region in a triangle
that contains a given point}
\usage{
rel.vert.tri(p, tri, M)
}
\arguments{
\item{p}{A 2D point for which \code{M}-vertex region
it resides in is to be determined in the
triangle \code{tri}.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}.}
}
\value{
A \code{list} with two elements
\item{rv}{Index of the vertex whose region contains point, \code{p};
index of the vertex is the same as the row
number in the triangle, \code{tri}}
\item{tri}{The vertices of the triangle, \code{tri},
where row number corresponds to the vertex index \code{rv}
with \code{rv=1} is row 1, \code{rv=2} is row 2, and \eqn{rv=3} is is row 3.}
}
\description{
Returns the index of the related vertex
in the triangle, \code{tri},
whose region contains point \code{p}.

Vertex regions are based on the general center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri}.
Vertices of the triangle \code{tri} are labeled
according to the row number the vertex is recorded.

If the point, \code{p}, is not inside \code{tri},
then the function yields \code{NA} as output.
The corresponding vertex region is the polygon
with the vertex, \code{M}, and projections from \code{M}
to the edges on the lines joining vertices
and \code{M} (see the illustration in the examples).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
M<-c(1.6,1.0)

P<-c(1.5,1.6)
rel.vert.tri(P,Tr,M)
#try also rel.vert.tri(P,Tr,M=c(2,2))
#center is not in the interior of the triangle

n<-20  #try also n<-40
set.seed(1)
Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

Rv<-vector()
for (i in 1:n)
{Rv<-c(Rv,rel.vert.tri(Xp[i,],Tr,M)$rv)}
Rv

Ds<-prj.cent2edges(Tr,M)

Xlim<-range(Tr[,1],Xp[,1])
Ylim<-range(Tr[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

if (dimension(M)==3) {M<-bary2cart(M,Tr)}
#need to run this when M is given in barycentric coordinates

plot(Tr,pch=".",xlab="",ylab="",
main="Illustration of M-Vertex Regions\n in a Triangle",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(Xp,pch=".",col=1)
L<-rbind(M,M,M); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty = 2)

xc<-Tr[,1]
yc<-Tr[,2]
txt.str<-c("rv=1","rv=2","rv=3")
text(xc,yc,txt.str)

txt<-rbind(M,Ds)
xc<-txt[,1]+c(-.02,.04,-.04,0)
yc<-txt[,2]+c(-.02,.04,.05,-.08)
txt.str<-c("M","D1","D2","D3")
text(xc,yc,txt.str)
text(Xp,labels=factor(Rv))
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rel.vert.triCM}}, \code{\link{rel.vert.triCC}},
\code{\link{rel.vert.basic.triCC}}, \code{\link{rel.vert.basic.triCM}},
\code{\link{rel.vert.basic.tri}}, and \code{\link{rel.vert.std.triCM}}
}
\author{
Elvan Ceyhan
}
