% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimatePcev.R
\name{estimatePcev}
\alias{estimatePcev}
\alias{estimatePcev.default}
\alias{estimatePcev.PcevClassical}
\alias{estimatePcev.PcevBlock}
\alias{estimatePcev.PcevSingular}
\title{Estimation of PCEV}
\usage{
estimatePcev(pcevObj, ...)

\method{estimatePcev}{default}(pcevObj, ...)

\method{estimatePcev}{PcevClassical}(pcevObj, shrink, index, ...)

\method{estimatePcev}{PcevBlock}(pcevObj, shrink, index, ...)

\method{estimatePcev}{PcevSingular}(pcevObj, shrink, index, ...)
}
\arguments{
\item{pcevObj}{A pcev object of class \code{PcevClassical}, \code{PcevBlock} or
\code{PcevSingular}}

\item{...}{Extra parameters.}

\item{shrink}{Should we use a shrinkage estimate of the residual variance?}

\item{index}{If \code{pcevObj} is of class \code{PcevBlock}, \code{index} is a vector
describing the block to which individual response variables correspond.}
}
\value{
A list containing the variance components, the first PCEV, the 
  eigenvalues of \eqn{V_R^{-1}V_M} and the estimate of the shrinkage 
  parameter \eqn{\rho}
}
\description{
\code{estimatePcev} estimates the PCEV.
}
\seealso{
\code{\link{computePCEV}}
}
