% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_matrix.R
\name{impute_matrix}
\alias{impute_matrix}
\title{Impute missing values in given matrix}
\usage{
impute_matrix(D, imputation_scheme)
}
\arguments{
\item{D}{The input data matrix.}

\item{imputation_scheme}{The values to replace missing \code{NA} values in \code{D}
with. Can be either:
\itemize{
\item A scalar numeric, indicating all \code{NA} values should be imputed with the
same scalar numeric value;
\item A vector of length \code{ncol(D)}, signifying column-specific imputation,
where each entry in the \code{imputation_scheme} vector corresponds to the
imputation value for each column in \code{D}; or
\item A matrix of dimension \code{dim(D)}, indicating an observation-specific
imputation scheme, where each entry in the \code{imputation_scheme} matrix
corresponds to the imputation value for each entry in \code{D}.
}}
}
\value{
The imputed matrix.
}
\description{
\code{impute_matrix()} imputes the missing \code{NA} values in a given matrix using a
given \code{imputation_scheme}.
}
\examples{
#### ------------Imputation with a scalar------------####
# simulate a small 5x5 mixture
D <- sim_data(5, 5)$D
# corrupt the mixture with 40\% missing observations
D_tilde <- sim_na(D, 0.4)$D_tilde
D_tilde
# impute missing values with 0
impute_matrix(D_tilde, 0)
# impute missing values with -1
impute_matrix(D_tilde, -1)

#### ------------Imputation with a vector------------####
# impute missing values with the column-mean
impute_matrix(D_tilde, apply(D_tilde, 2, mean, na.rm = TRUE))
# impute missing values with the column-min
impute_matrix(D_tilde, apply(D_tilde, 2, min, na.rm = TRUE))

#### ------------Imputation with a matrix------------####
# impute missing values with random Gaussian noise
noise <- matrix(rnorm(prod(dim(D_tilde))), nrow(D_tilde), ncol(D_tilde))
impute_matrix(D_tilde, noise)

#### ------------Imputation with LOD/sqrt(2)------------####
D <- sim_data(5, 5)$D
lod_info <- sim_lod(D, q = 0.2)
D_tilde <- lod_info$D_tilde
D_tilde
lod <- lod_info$lod
impute_matrix(D_tilde, lod / sqrt(2))
}
\seealso{
\code{\link[=sim_na]{sim_na()}}, \code{\link[=sim_lod]{sim_lod()}}, \code{\link[=sim_data]{sim_data()}}
}
