% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cow_capitals}
\alias{cow_capitals}
\title{A complete list of capitals and capital transitions for Correlates of War state system members}
\format{
A data frame with the following 7 variables.
\describe{
\item{\code{ccode}}{a numeric vector for the Correlates of War state code}
\item{\code{statenme}}{a character vector for the state}
\item{\code{capital}}{a character vector for the name of the capital}
\item{\code{stdate}}{a start date for the capital. See details section for more information.}
\item{\code{enddate}}{an end date for the capital. See details section for more information.}
\item{\code{lat}}{a numeric vector of the latitude coordinates for the capital}
\item{\code{lng}}{a numeric vector of the longitude coordinates for the capital}
}
}
\usage{
cow_capitals
}
\description{
This is a complete list of capitals and capital transitions for Correlates of
War state system members. I use it internally for calculating
capital-to-capital distances in the \code{add_capital_distances()} function.
}
\details{
For convenience, the dates for most of these entries allows for some generous
coverage prior to its actual emergence in the state system or after its
actual exit from it. This is largely in consideration of the other state
system and its extension to potential daily format. However, the functions
that use the \code{cow_capitals} data will not create observations for states that
did not exist at a given point in time.

Sometimes, a city is entered in these data to correspond with what makes it
easy for the geocoder, not necessarily what the name of the city was or what
it might be commonly called. I say this because I know it's heresy to call
Ho Chi Minh City the capital of the Republic of Vietnam. I'm aware.

The data should be current as of the end of 2024. Indonesia is the most
likely candidate to require an update to these data and I am just having to
remind myself of this to make sure I don't forget.

Cases where a start year is not 1816 indicate a capital transition. For
example, Brazil's capital moved from Rio de Janeiro to Brasilia (a planned
capital) in 1960. Only 25 states in the data experienced a capital transition.
The most recent was Burundi in 2018.

Kazakhstan renamed its capital for the state leader in 2019. These data
retain the name of Astana and successfully outlived the short-lived name of
"Nur-Sultan". The city returned to its original name in 2022.

The capitals data are not without some peculiarities. Prominently, Portugal
transferred the Portuguese court from Lisbon to Rio de Janeiro from 1808 to
1821. \emph{This is recorded in the data.} A knowledge of the inter-state conflict
data will note there was no war or dispute between, say, Portugal and Spain
(or Portugal and any other country) at any point during this time, but it
does create some weirdness that would suggest a massive distance between two
countries, like Portugal and Spain, that are otherwise land-contiguous.

On Spain: the republican government moved the capital at the start of the
civil war (in 1936) to Valencia. However, it abandoned this capital by 1937.
I elect to not record this capital transition.

The data also do some (I think) reasonable back-dating of capitals to
coincide with states in transition without necessarily formal capitals by the
first appearance in the state system membership data. These concern Lithuania,
Kazakhstan, and the Philippines. Kaunas is the initial post-independence
capital of Lithuania. Almaty is the initial post-independence capital of
Kazakhstan. Quezon City is the initial post-independence capital of the
Philippines. This concerns, at the most, one or two years for each of these
three countries.

The \code{data-raw} directory have a raw spreadsheet with these data in their raw
form, along with comments I make about the transitions in question. Dates
where this is a transition are coded as the start and the end date for the
previous capital is the day before. I will confess that some decision rules
for what constitutes the transfer of the capital can be understood as ad hoc.
In modern instances, I generally privilege the legal documentation. For
example, Ivory Coast's transfer was declared in 1983 even if much of the
transfer wasn't completed until 2011. In this case, I prioritize 1983 as
the legal transfer of the capital. In the case of Australia, Canberra was
such a planned experiment that its announcement in 1908 coincided with no
name for the new location and the need for the government to buy up states
to build infrastructure. Even if it was announced with its name in 1913, I
don't record the transition until 1927 (when it opened the provisional
house for parliament). Much like the case above in Spain, I elect to ignore
cases where governments were declared in absentia or during an active conflict.
You can check the comments section of the raw spreadsheet for some of my
rationale.
}
\keyword{datasets}
