% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{is_strictness_fulfilled}
\alias{is_strictness_fulfilled}
\title{is_strictness_fulfilled}
\usage{
is_strictness_fulfilled(model, results, strictness)
}
\arguments{
\item{model}{(Model) Model for parameter specific strictness.}

\item{results}{(ModelfitResults) ModelfitResults object}

\item{strictness}{(str) A strictness expression}
}
\value{
(logical) A logical indicating whether the strictness criteria are fulfilled or not.
}
\description{
Takes a ModelfitResults object and a statement as input and returns TRUE/FALSE
if the evaluation of the statement is TRUE/FALSE.
}
\examples{
\dontrun{
res <- load_example_modelfit_results('pheno')
model <- load_example_model('pheno')
is_strictness_fulfilled(model, res, "minimization_successful or rounding_errors")
}

}
