% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_initial_condition}
\alias{set_initial_condition}
\title{set_initial_condition}
\usage{
set_initial_condition(model, compartment, expression, time = 0)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{compartment}{(str) Name of the compartment}

\item{expression}{(numeric or str or Expr) The expression of the initial condition}

\item{time}{(numeric or str or Expr) Time point. Default 0}
}
\value{
(model) Pharmpy model object
}
\description{
Set an initial condition for the ode system

If the initial condition is already set it will be updated. If the initial condition
is set to zero at time zero it will be removed (since the default is 0).
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- set_initial_condition(model, "CENTRAL", 10)
get_initial_conditions(model)
}

}
