% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_safe_file_name.R
\name{get_safe_file_name}
\alias{get_safe_file_name}
\title{Get a safe name to export a file without overwriting}
\usage{
get_safe_file_name(
  data,
  name = NULL,
  format = "xlsx",
  overwrite = FALSE,
  time_in_name = FALSE
)
}
\arguments{
\item{data}{The object to be exported.}

\item{name}{A desired name for the exported file. If no name is provided,
the file will inherit the object's name.}

\item{format}{The format of the exported file. Default is 'xlsx'.}

\item{overwrite}{A logical to indicate whether preexisting files
with identical names should be overwritten. Default is 'FALSE'.}

\item{time_in_name}{A logical to indicate whether a timestamp
should be included in the file's name.}
}
\value{
A safe name for exporting the file, as a "character string", and also indicated in a message.
}
\description{
Get a safe name to export a file without overwriting
}
\examples{
\donttest{
if (FALSE) {
  library(phdcocktail)
  get_safe_file_name(mtcars)
}
}

}
