% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phinterval.R
\name{phinterval}
\alias{phinterval}
\title{Create a new phinterval}
\usage{
phinterval(
  start = POSIXct(),
  end = POSIXct(),
  tzone = NULL,
  by = NULL,
  order_by = FALSE
)
}
\arguments{
\item{start, end}{\verb{[POSIXct / POSIXlt / Date]}

A pair of datetime vectors to represent the endpoints of the spans. \code{start}
and \code{end} are recycled to a common length using vctrs-style recycling rules.}

\item{tzone}{\verb{[character(1)]}

A time zone to display the \verb{<phinterval>} in. If \code{tzone} is \code{NULL}
(the default), then the time zone is taken from that of \code{start}.

\code{tzone} can be any non-\code{NA} string, but unrecognized time zones (see
\code{\link[=is_recognized_tzone]{is_recognized_tzone()}}) will be formatted using \code{"UTC"} with a warning.}

\item{by}{\verb{[vector / data.frame / NULL]}

An optional grouping vector or data frame. When provided, \code{start[i]} and
\code{end[i]} pairs are grouped by \code{by[i]}, creating one phinterval element per
unique value of \code{by}. Overlapping or abutting spans within each group are
merged. If \code{NULL} (the default), each \code{start}/\code{end} pair creates a separate
phinterval element. \code{by} is recycled to match the common length of \code{start}
and \code{end}.

\code{by} may be any vector in the vctrs sense. See \code{\link[vctrs:vector-checks]{vctrs::obj_is_vector()}}
for details.}

\item{order_by}{\verb{[TRUE / FALSE]}

Should the output be ordered by the values in \code{by}? If \code{FALSE} (the default),
the output order matches the first appearance of each group in \code{by}. If \code{TRUE},
the output is sorted by the unique values of \code{by}. Only used when \code{by} is not
\code{NULL}.}
}
\value{
When \code{by = NULL}, a \verb{<phinterval>} vector the same length as the recycled
length of \code{start} and \code{end}.

When \code{by} is provided, a \verb{<phinterval>} vector with one element per unique
value of \code{by}.
}
\description{
\code{phinterval()} creates a new \verb{<phinterval>} vector from start and end times.
A phinterval (think "potentially holey interval") is a span of time which may
contain gaps.
}
\details{
The \verb{<phinterval>} class is designed as a generalization of the
\code{\link[lubridate:interval]{lubridate::interval()}}. While an \verb{<Interval>} element represents a
single contiguous span between two fixed times, a \verb{<phinterval>} element can
represent a time span that may be empty, contiguous, or disjoint (i.e. containing
gaps). Each element of a \verb{<phinterval>} is stored as a (possibly empty) set of
non-overlapping and non-abutting time spans.

When \code{by = NULL} (the default), \code{phinterval()} creates scalar phinterval
elements, where each element contains a single time span from \code{start[i]} to
\code{end[i]}. This is equivalent to \code{\link[lubridate:interval]{lubridate::interval()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{interval(start, end, tzone = tzone)   # <Interval> vector
phinterval(start, end, tzone = tzone) # <phinterval> vector
}\if{html}{\out{</div>}}

When \code{by} is provided, \code{phinterval()} groups the \code{start}/\code{end} pairs by the
values in \code{by}, creating phinterval elements that may contain multiple disjoint
time spans. Overlapping or abutting spans within each group are automatically
merged.
}
\section{Differences from interval()}{


While \code{phinterval()} is designed as a drop-in replacement for
\code{\link[lubridate:interval]{lubridate::interval()}}, there are three key differences regarding the
\code{start} and \code{end} arguments:
\itemize{
\item \strong{Stricter recycling}: \code{phinterval()} uses vctrs recycling rules instead of
base R recycling. Length-1 vectors recycle to any length, but mismatched
lengths (e.g., 2 vs 3) cause an error.
\item \strong{No character inputs}: \code{phinterval()} does not accept character vectors
for \code{start} and \code{end}. Character starts and ends (e.g. "2021-01-01") must
be converted to datetimes first using \code{\link[=as.POSIXct]{as.POSIXct()}}, \code{\link[lubridate:ymd]{lubridate::ymd()}},
or a similar function.
\item \strong{Standardized endpoints}: \code{\link[lubridate:interval]{lubridate::interval()}} allows negative length
spans where \code{end[i] < start[i]}. \code{phinterval()} flips the order of the i-th
span's endpoints when \code{end[i] < start[i]} to ensure that all spans are
positive, similar to \code{\link[lubridate:interval]{lubridate::int_standardize()}}.
}
}

\examples{
# Scalar phintervals (equivalent to interval())
phinterval(
  start = as.Date(c("2000-01-01", "2000-02-01")),
  end = as.Date(c("2000-02-01", "2000-03-01"))
)

# Grouped phintervals with multiple spans per element
phinterval(
  start = as.Date(c("2000-01-01", "2000-03-01", "2000-02-01")),
  end = as.Date(c("2000-02-01", "2000-04-01", "2000-03-01")),
  by = c(1, 1, 2)
)

# Overlapping spans are merged within groups
phinterval(
  start = as.Date(c("2000-01-01", "2000-01-15")),
  end = as.Date(c("2000-02-01", "2000-02-15")),
  by = 1
)

# Empty phinterval
phinterval()

# Specify time zone
phinterval(
  start = as.Date("2000-01-01"),
  end = as.Date("2000-02-01"),
  tzone = "America/New_York"
)

}
