% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\docType{data}
\name{phinterval_options}
\alias{phinterval_options}
\title{Package options}
\description{
The \code{phinterval} package uses the following global options to control
printing and default behaviors. These options can be set using \code{\link[=options]{options()}}
and queried using \code{\link[=getOption]{getOption()}}.
}
\section{Options}{

\itemize{
\item \code{phinterval.print_max_width}: Character width at which a printed or
formatted \verb{<phinterval>} element is truncated for display, default: \code{90}.
}
}

\examples{
monday <- phinterval(as.Date("2025-11-10"), as.Date("2025-11-11"))
friday <- phinterval(as.Date("2025-11-14"), as.Date("2025-11-15"))

# Get the default setting
getOption("phinterval.print_max_width")
phint_squash(c(monday, friday))

# Change the setting for the session duration
opts <- options(phinterval.print_max_width = 25)
phint_squash(c(monday, friday))

# Reset to the previous settings
options(opts)

}
\keyword{datasets}
