test_that("Far_red waveband is correct for default", {
  expect_equal(Far_red(), Far_red("ISO"))
})

test_that("Far_red waveband is correct for \"ISO\"", {
  expect_message(wb <- Far_red(std = "ISO"))
  expect_equal(wl_range(wb), c(NA_real_, NA_real_))
  expect_equal(labels(wb)$label, "Not available")
  expect_equal(labels(wb)$name, "Not available")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_true(all(is.na(wb$hinges)))
  expect_equal(length(wb$hinges), 4L)
})

test_that("Far_red waveband is correct for \"Smith\"", {
  expect_message(Far_red("Smith"))
  expect_equal(Far_red("Smith"), Far_red("Smith10"))
})

test_that("wl range is correct for \"Smith10\"", {
  wb <- Far_red(std = "Smith10")
  expect_equal(wl_range(wb), c(725, 735))
  expect_equal(labels(wb)$label, "FR")
  expect_equal(labels(wb)$name, "FarRed.Smith10")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"Smith20\"", {
  wb <- Far_red(std = "Smith20")
  expect_equal(wl_range(wb), c(720, 740))
  expect_equal(labels(wb)$label, "FR")
  expect_equal(labels(wb)$name, "FarRed.Smith20")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("Far_red waveband is correct for \"Apogee\"", {
  wb <- Far_red("Apogee")
  expect_equal(wl_range(wb), c(720, 740))
  expect_equal(labels(wb)$label, "FR")
  expect_equal(labels(wb)$name, "FarRed.Apogee")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"Inada\"", {
  wb <- Far_red(std = "Inada")
  expect_equal(wl_range(wb), c(700, 800))
  expect_equal(labels(wb)$label, "FR")
  expect_equal(labels(wb)$name, "FarRed.Inada")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"broad\"", {
  wb <- Far_red(std = "broad")
  expect_equal(wl_range(wb), c(700, 800))
  expect_equal(labels(wb)$label, "FR")
  expect_equal(labels(wb)$name, "FarRed.broad")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"broad\"", {
  expect_equal(Far_red("Broad"), Far_red("broad"))
})

test_that("wl range is correct for \"RS\"", {
  wb <- Far_red(std = "RS")
  expect_equal(wl_range(wb), c(700, 800))
  expect_equal(labels(wb)$label, "FR")
  expect_equal(labels(wb)$name, "FarRed.RS")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatMSS\"", {
  wb <- Far_red(std = "LandsatMSS")
  expect_equal(wl_range(wb), c(700, 800))
  expect_equal(labels(wb)$label, "FR")
  expect_equal(labels(wb)$name, "FarRed.LandsatMSS")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"Warrington\"", {
  wb <- Far_red(std = "Warrington")
  expect_equal(wl_range(wb), c(700, 850))
  expect_equal(labels(wb)$label, "FR")
  expect_equal(labels(wb)$name, "FarRed.Warrington")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"Sellaro\"", {
  wb <- Far_red(std = "Sellaro")
  expect_equal(wl_range(wb), c(700, 750))
  expect_equal(labels(wb)$label, "FR")
  expect_equal(labels(wb)$name, "FarRed.Sellaro")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"RedEdge40\"", {
  wb <- Far_red(std = "RedEdge40")
  expect_equal(wl_range(wb), c(705, 745))
  expect_equal(labels(wb)$label, "FR")
  expect_equal(labels(wb)$name, "FarRed.RedEdge40")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"RedEdge20\"", {
  wb <- Far_red(std = "RedEdge20")
  expect_equal(wl_range(wb), c(715, 735))
  expect_equal(labels(wb)$label, "FR")
  expect_equal(labels(wb)$name, "FarRed.RedEdge20")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("Far_red waveband is correct for bad std", {
  expect_warning(wb <- Far_red(std = "bad-std"))
  expect_equal(wl_range(wb), c(NA_real_, NA_real_))
  expect_equal(labels(wb)$label, "Not available")
  expect_equal(labels(wb)$name, "Not available")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_true(all(is.na(wb$hinges)))
  expect_equal(length(wb$hinges), 4L)
})
