% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_week.R
\name{scale_x_week}
\alias{scale_x_week}
\title{Date scale with breaks specified by week}
\usage{
scale_x_week(
  name = waiver(),
  week_breaks = waiver(),
  labels = waiver(),
  date_labels = waiver(),
  week_minor_breaks = waiver(),
  oob = scales::oob_keep,
  limits = NULL,
  ...,
  week_start = getOption("phylepic.week_start")
)
}
\arguments{
\item{name, labels, date_labels, oob, limits, ...}{see \code{\link[ggplot2:scale_date]{ggplot2::scale_x_date()}}.}

\item{week_breaks, week_minor_breaks}{frequency of breaks in number of weeks (e.g. \code{2} for fortnightly breaks).}

\item{week_start}{Day the week begins (defaults to Monday).
Can be specified as a case-insensitive English weekday name such as "Monday"
or an integer. Since you generally won't want to mix definitions, it is
more convenient to control this globally with the \code{"phylepic.week_start"}
option, e.g. \code{options(phylepic.week_start = "Monday")}.}
}
\value{
a ggplot scale object.
}
\description{
This produces a scale that is measured in days as with \link[ggplot2:scale_date]{ggplot2::scale_x_date},
however it will snap breaks and limits to week boundaries so that things
work as intended when binning by week.
}
\details{
Any \code{limits} specified are converted to the nearest week boundary that
includes the specified dates, i.e. the lower limit will be rounded down and
the upper limit rounded up so that the limits are week boundaries.
}
