% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translink_prob_transmit.R
\name{translink_prob_transmit}
\alias{translink_prob_transmit}
\title{Calculate probability of transmission}
\usage{
translink_prob_transmit(
  sensitivity,
  specificity,
  rho,
  M,
  R,
  assumption = "mtml"
)
}
\arguments{
\item{sensitivity}{scalar or vector giving the sensitivity of the linkage criteria}

\item{specificity}{scalar or vector giving the specificity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen}

\item{assumption}{a character vector indicating which assumptions about transmission and linkage criteria. Default = \code{'mtml'}. Accepted arguments are:
\enumerate{
\item \code{'stsl'} for the single-transmission single-linkage assumption.
\item \code{'mtsl'} for the multiple-transmission single-linkage assumption.
\item \code{'mtml'} for the multiple-transmission multiple-linkage assumption.
}}
}
\value{
scalar or vector giving the probability of transmission between two cases given linkage by phylogenetic criteria
}
\description{
This function calculates the probability that two cases are linked by direct transmission
given that they have been linked by phylogenetic criteria.
Assumptions about transmission and linkage (single or multiple) can be specified.
}
\examples{
translink_prob_transmit(sensitivity=0.99, specificity=0.9, rho=0.5, M=100, R=1)

}
\seealso{
Other transmission linkage functions: 
\code{\link{translink_expected_links_obs_mtml}()},
\code{\link{translink_expected_links_obs_mtsl}()},
\code{\link{translink_expected_links_obs_stsl}()},
\code{\link{translink_expected_links_obs}()},
\code{\link{translink_expected_links_true_mtml}()},
\code{\link{translink_expected_links_true_mtsl}()},
\code{\link{translink_expected_links_true_stsl}()},
\code{\link{translink_expected_links_true}()},
\code{\link{translink_fdr}()},
\code{\link{translink_prob_transmit_mtml}()},
\code{\link{translink_prob_transmit_mtsl}()},
\code{\link{translink_prob_transmit_stsl}()},
\code{\link{translink_samplesize}()},
\code{\link{translink_tdr}()}
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{transmission linkage functions}
