% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vartrack_prob_prev.R
\name{vartrack_prob_prev}
\alias{vartrack_prob_prev}
\title{Calculate confidence in a variant estimate given a sample size}
\usage{
vartrack_prob_prev(p_v1, n, omega, precision, c_ratio = 1, sampling_freq)
}
\arguments{
\item{p_v1}{variant prevalence (proportion)}

\item{n}{sample size}

\item{omega}{probability of sequencing (or other characterization) success}

\item{precision}{desired precision in variant prevalence estimate}

\item{c_ratio}{coefficient of detection ratio, calculated as the ratio of the coefficients of variant 1 to variant 2. Default = 1 (no bias)}

\item{sampling_freq}{the sampling frequency (must be either 'xsect' in current implementation)}
}
\value{
scalar of expected sample size
}
\description{
This function calculates the probability of accurately estimating variant prevalence
given a sample size and desired precision in the variant prevalence estimate.
Currently, only cross-sectional sampling is supported.
}
\examples{
vartrack_prob_prev(p_v1 = 0.1, n = 200, omega = 0.8, precision = 0.1, 
c_ratio = 1, sampling_freq = 'xsect')

}
\seealso{
Other variant prevalence estimation functions: 
\code{\link{vartrack_prob_prev_xsect}()},
\code{\link{vartrack_samplesize_prev_xsect}()},
\code{\link{vartrack_samplesize_prev}()}

Other variant tracking functions: 
\code{\link{vartrack_cod_ratio}()},
\code{\link{vartrack_prob_detect_cont}()},
\code{\link{vartrack_prob_detect_xsect}()},
\code{\link{vartrack_prob_detect}()},
\code{\link{vartrack_prob_prev_xsect}()},
\code{\link{vartrack_samplesize_detect_cont}()},
\code{\link{vartrack_samplesize_detect_xsect}()},
\code{\link{vartrack_samplesize_detect}()},
\code{\link{vartrack_samplesize_prev_xsect}()},
\code{\link{vartrack_samplesize_prev}()}
}
\author{
Shirlee Wohl, Elizabeth C. Lee, Bethany L. DiPrete, and Justin Lessler
}
\concept{variant prevalence estimation functions}
\concept{variant tracking functions}
