% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vartrack_samplesize_detect_xsect.R
\name{vartrack_samplesize_detect_xsect}
\alias{vartrack_samplesize_detect_xsect}
\title{Calculate sample size needed for variant detection assuming cross-sectional sampling}
\usage{
vartrack_samplesize_detect_xsect(p_v1, prob, omega, c_ratio = 1)
}
\arguments{
\item{p_v1}{variant prevalence (proportion)}

\item{prob}{desired probability of detection}

\item{omega}{probability of sequencing (or other characterization) success}

\item{c_ratio}{coefficient of detection ratio, calculated as the ratio of the coefficients of variant 1 to variant 2. Default = 1 (no bias)}
}
\value{
scalar of expected sample size
}
\description{
This function calculates the sample size needed for detecting the presence of a variant
given a desired probability of detection and assuming a single, cross-sectional sample of detected infections.
}
\examples{
vartrack_samplesize_detect_xsect(p_v1 = 0.1, prob = 0.95, omega = 0.8, c_ratio = 1)

}
\seealso{
Other variant detection functions: 
\code{\link{vartrack_prob_detect_cont}()},
\code{\link{vartrack_prob_detect_xsect}()},
\code{\link{vartrack_prob_detect}()},
\code{\link{vartrack_samplesize_detect_cont}()},
\code{\link{vartrack_samplesize_detect}()}

Other variant tracking functions: 
\code{\link{vartrack_cod_ratio}()},
\code{\link{vartrack_prob_detect_cont}()},
\code{\link{vartrack_prob_detect_xsect}()},
\code{\link{vartrack_prob_detect}()},
\code{\link{vartrack_prob_prev_xsect}()},
\code{\link{vartrack_prob_prev}()},
\code{\link{vartrack_samplesize_detect_cont}()},
\code{\link{vartrack_samplesize_detect}()},
\code{\link{vartrack_samplesize_prev_xsect}()},
\code{\link{vartrack_samplesize_prev}()}
}
\author{
Shirlee Wohl, Elizabeth C. Lee, Bethany L. DiPrete, and Justin Lessler
}
\concept{variant detection functions}
\concept{variant tracking functions}
