% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vartrack_samplesize_prev_xsect.R
\name{vartrack_samplesize_prev_xsect}
\alias{vartrack_samplesize_prev_xsect}
\title{Calculate sample size needed for variant prevalence estimation under cross-sectional sampling}
\usage{
vartrack_samplesize_prev_xsect(p_v1, prob, precision, omega, c_ratio = 1)
}
\arguments{
\item{p_v1}{variant prevalence (proportion)}

\item{prob}{desired confidence in variant prevalence estimate}

\item{precision}{desired precision in variant prevalence estimate}

\item{omega}{probability of sequencing (or other characterization) success}

\item{c_ratio}{coefficient of detection ratio, calculated as the ratio of the coefficients of variant 1 to variant 2. Default = 1 (no bias)}
}
\value{
scalar of sample size
}
\description{
This function calculates the sample size needed for estimating variant prevalence
given a desired confidence and desired precision in the variant prevalence estimate
and assuming a single, cross-sectional sample of detected infections.
}
\examples{
vartrack_samplesize_prev_xsect(p_v1 = 0.1, prob = 0.95, precision = 0.25, omega = 0.8, c_ratio = 1)

}
\seealso{
Other variant prevalence estimation functions: 
\code{\link{vartrack_prob_prev_xsect}()},
\code{\link{vartrack_prob_prev}()},
\code{\link{vartrack_samplesize_prev}()}

Other variant tracking functions: 
\code{\link{vartrack_cod_ratio}()},
\code{\link{vartrack_prob_detect_cont}()},
\code{\link{vartrack_prob_detect_xsect}()},
\code{\link{vartrack_prob_detect}()},
\code{\link{vartrack_prob_prev_xsect}()},
\code{\link{vartrack_prob_prev}()},
\code{\link{vartrack_samplesize_detect_cont}()},
\code{\link{vartrack_samplesize_detect_xsect}()},
\code{\link{vartrack_samplesize_detect}()},
\code{\link{vartrack_samplesize_prev}()}
}
\author{
Shirlee Wohl, Elizabeth C. Lee, Bethany L. DiPrete, and Justin Lessler
}
\concept{variant prevalence estimation functions}
\concept{variant tracking functions}
