% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tone-mapping.R
\name{tm_reinhard}
\alias{tm_reinhard}
\alias{tm_reinhard_basic}
\alias{tm_reinhard_variant}
\title{Reinhard's global tone mapping}
\usage{
tm_reinhard(arr)

tm_reinhard_basic(arr)

tm_reinhard_variant(arr)
}
\arguments{
\item{arr}{array or matrix}
}
\value{
New array with adjusted color values
}
\description{
Tone mapping is a method for adapting an HDR image for display on a
low dynamic range device.  There are three included variants of Reinhard's global
tone mapping operator.
}
\details{
\describe{
  \item{\code{tm_reinhard()}}{[RGB] Reinhard's operator with a correction
        for the maximum luminance}
  \item{\code{tm_reinhard_basic()}}{[RGB images] Reinhard's operator applied
        equally to all colour channels}
  \item{\code{tm_reinhard_variant()}}{[RGB or Gray images] A combination of
        the above two methods}
}
These functions are based on Reinhard (2002) 
"Photographic tone reproduction for digital images"
}
\examples{
filename <- system.file("image", "rstats.pfm.bz2", package = "picohdr")
image <- read_pfm(filename)
image <- tm_reinhard_basic(image)
image <- adj_gamma(image)
plot(image)
}
