% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extract.pim.summary.R
\docType{methods}
\name{Extract.pim.summary}
\alias{Extract.pim.summary}
\alias{[,pim.summary-method}
\title{Extract method for pim.summary objects}
\usage{
\S4method{[}{pim.summary}(x, i, j, drop = TRUE)
}
\arguments{
\item{x}{a \code{\link{pim.summary}} object to extract information from.}

\item{i}{indices specifying row to extract or replace. They are used in the same way as you woul after transforming \code{x} to a matrix.}

\item{j}{see i, but for columns}

\item{drop}{see \code{\link[base:Extract]{Extract}}}
}
\value{
the selected matrix
}
\description{
This method allows to extract data directly from a \code{\link{pim.summary}}
object. It's exactly the same as extracting from \code{as.matrix(thesummary)}.
}
\examples{
data(FEVData)
Model <- pim(FEV~ Smoke*Sex , data=FEVData)

thesummary <- summary(Model)
thesummary[,2:3]
thesummary["Sex"]

}
