% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_trans.R
\name{unit_trans}
\alias{unit_trans}
\title{pk.unit.trans}
\usage{
unit_trans(value, from, to, mw = NULL)
}
\arguments{
\item{value}{Vector or 1 column form data frame, Must be numeric.}

\item{from}{Vector or 1 column form data frame, Must be character.}

\item{to}{Vector or 1 column form data frame, Must be character.}

\item{mw}{molecular weight,Vector or 1 column form data frame, Must be numeric.}
}
\value{
Numerical Vector.
}
\description{
Achieve numerical conversion between units commonly used in pharmacokinetics.
such as: mg to ng, nmol to mol, ml to L, noml to mg, nmol/L to ng/mL.
}
\examples{
unit_trans(1,"nmol/L","ng/mL",mw=150000) #return 150
unit_trans(1,"nM","ng/mL",mw=150000) #return 150
unit_trans(1,"nmol","mg",mw=150000) #return 0.15
unit_trans(1,"mg","ug") #return 1000
unit_trans(1,"mL","uL") #return 1000
}
