% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphClasses.R
\name{DirectedGraph}
\alias{DirectedGraph}
\title{Directed Graph Network Model}
\description{
R6 class defining a directed graph model for representing a
network, including methods to calculate various measures from graph
theory. The \link[igraph:igraph-package]{igraph} package is used as a
backend for calculations.

This class isn't intended to be initialized directly; instead,
\link[=AbstractGraphReporter]{network reporter objects} will initialize it as
its \code{pkg_graph} field. If you have a network reporter named
\code{reporter}, then you access this object's public
interface through \code{pkg_graph}---for example,

\preformatted{reporter$pkg_graph$node_measures('hubScore')}
}
\seealso{
DirectedGraphMeasures
}
\concept{Graph Classes}
\section{Super class}{
\code{\link[pkgnet:AbstractGraph]{pkgnet::AbstractGraph}} -> \code{DirectedGraph}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{default_node_measures}}{character vector of default node measures. 
See \emph{Node Measures} section in \link{DirectedGraphMeasures} for details about each measure. Read-only.}

\item{\code{default_graph_measures}}{character vector of default graph measures. 
See \emph{Graph Measures} section in \link{DirectedGraphMeasures} for details about each measure. Read-only.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DirectedGraph-clone}{\code{DirectedGraph$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractGraph" data-id="graph_measures"><a href='../../pkgnet/html/AbstractGraph.html#method-AbstractGraph-graph_measures'><code>pkgnet::AbstractGraph$graph_measures()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractGraph" data-id="initialize"><a href='../../pkgnet/html/AbstractGraph.html#method-AbstractGraph-initialize'><code>pkgnet::AbstractGraph$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractGraph" data-id="node_measures"><a href='../../pkgnet/html/AbstractGraph.html#method-AbstractGraph-node_measures'><code>pkgnet::AbstractGraph$node_measures()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractGraph" data-id="print"><a href='../../pkgnet/html/AbstractGraph.html#method-AbstractGraph-print'><code>pkgnet::AbstractGraph$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DirectedGraph-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DirectedGraph-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DirectedGraph$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
