% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plastic_estimation.R
\name{plastic.ci}
\alias{plastic.ci}
\title{Confidence intervals of plastic prevalence probability}
\usage{
plastic.ci(plastic_abs_pres, max_sample_size = 300, bs_rep = 1000,
  lower_ci = 0.025, upper_ci = 0.975)
}
\arguments{
\item{plastic_abs_pres}{numeric vector, containing a binary values with 0
or no for absence of plastic, and 1 or yes for presence of plastic.}

\item{max_sample_size}{integer, specifying the maximum number of
samples to use for estimating the prevalence of plastic debris.
By default 300 samples. Increasing sample sizes substantially increases
computational time.}

\item{bs_rep}{integer, specifying the number of bootstrap replications.
By default 1000 replications.}

\item{lower_ci}{numeric, specifying lower confidence interval.
By default 2.5\%, based on Efron and Tibshirani (1993)}

\item{upper_ci}{numeric, specifying upper confidence interval.
By default 97.5\% default, based on Efron and Tibshirani (1993).}
}
\value{
A list (cidtf) with a data frame with sample sizes, mean CI,
lower CI, upper CI, and a matrix (prevprob) with prevalence probability
of plastic debris for all sample sizes and their estimated prevalence of debris.
}
\description{
Bootstrap simulations to estimate 95\% bootstrapped CIs for the
prevalence of debris obtained with different sample sizes.
}
\note{
The confidence intervals are calculated in a sequence of varying
sample sizes, i.e. 1,2,3...,n and the function can be also used for defining
sample sizes that would provide 95\% CIs with the desired accuracy.
}
\examples{
plastic.ci(rbinom(1000,1,0.5), 30, 100)
}
\references{
Efron, B., & Tibshirani, R. (1993). An introduction to the Bootstrap.
 Boca Raton: Chapman & Hall.
}
\seealso{
\code{\link{plastic.prev.prob}}, \code{\link{prevalence_plot}}
}
