% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotwidgets.R, R/widgets.R
\docType{package}
\name{plotwidgets}
\alias{plotWidget}
\alias{plotwidgets}
\alias{plotwidgets-package}
\alias{wgBarplot}
\alias{wgBoxpie}
\alias{wgBurst}
\alias{wgPie}
\alias{wgPlanets}
\alias{wgRing}
\alias{wgRoccurve}
\alias{wgRug}
\alias{wgSpider}
\title{Plot widgets}
\usage{
plotWidget(type = "pie", x = 0.5, y = 0.5, w = 1, h = 1, v,
  col = NULL, border = NA, new = FALSE, aspect = 1, ...)

wgPie(x = 0.5, y = 0.5, w = 1, h = 1, v, col = NULL, border = NA,
  new = FALSE, res = 100, aspect = 1, adj = 0, labels = NULL,
  label.params = NULL)

wgRing(x = 0.5, y = 0.5, w = 1, h = 1, v, col = NULL, border = NA,
  new = FALSE, res = 100, aspect = 1, adj = 0, start = 0.5,
  labels = NULL, label.params = NULL)

wgPlanets(x = 0.5, y = 0.5, w = 1, h = 1, v, col = NULL,
  border = NA, new = FALSE, res = 100, aspect = 1, adj = 0,
  labels = NULL, label.params = NULL)

wgBurst(x = 0.5, y = 0.5, w = 1, h = 1, v, col = NULL, border = NA,
  new = FALSE, res = 100, aspect = 1, adj = 0, max = NULL,
  labels = NULL, label.params = NULL)

wgRug(x = 0.5, y = 0.5, w = 1, h = 1, v, col = NULL, border = NA,
  labels = NULL, label.params = NULL, new = FALSE, aspect = NULL,
  horizontal = TRUE, rev = FALSE)

wgBarplot(x = 0.5, y = 0.5, w = 1, h = 1, v, col = NULL,
  border = NA, labels = NULL, label.params = NULL, new = FALSE,
  aspect = NULL, max = NULL)

wgBoxpie(x = 0.5, y = 0.5, w = 1, h = 1, v, col = NULL, border = NA,
  labels = NULL, label.params = NULL, new = FALSE, aspect = 1,
  grid = 3)

wgRoccurve(x = 0.5, y = 0.5, w = 1, h = 1, v, col = NULL,
  border = NA, new = FALSE, fill = FALSE, lwd = 1, aspect = 1)

wgSpider(x = 0.5, y = 0.5, w = 1, h = 1, v, col = NULL, border = NA,
  new = FALSE, min = NA, max = NA, tick.labels = FALSE, fill = FALSE,
  lwd = 1, aspect = 1)
}
\arguments{
\item{type}{what kind of plot. To list all available plot types, use
\code{listPlotWidgets}. Instead of the canonical name such as "wgSpider", you
can simply use "spider"}

\item{x, y}{coordinates at which to draw the plot}

\item{w, h}{width and height of the plot}

\item{v}{sizes of the slices}

\item{col}{character vector with colors (palette). A default palette is chosen if the argument is NULL}

\item{border}{color of the border. Use NA (default) for no border, and
NULL for a border in the par("fg") color. No effect in spider plots.}

\item{new}{Whether to call plot.new() before drawing the widget}

\item{aspect}{the actual ratio between screen width and screen height.
Parameters w and h will be scaled accordingly.}

\item{...}{Any further arguments passed to plotting functions}

\item{res}{for pies, rings, planets and bursts: resolution (number of polygon edges in a full circle)}

\item{adj}{for spider plots, burst plots, planet plots and pies: adjust the start by
"adj" degrees. For example, to turn the plot clockwise by 90 degrees, use
adj=90}

\item{labels}{character vector}

\item{label.params}{a named list with arguments passed to text() for
drawing labels (e.g. cex, col etc.)}

\item{start}{For ring plots, the inner radius of the ring}

\item{max}{For burst plots -- a maximum value used to scale other values
to make different plots comparable. For spider plots: the
maximum of the scale on spider plot spikes.}

\item{horizontal}{for rug plots: whether the stacked bar should be
horizontal (default), or vertical}

\item{rev}{logical, for rug plots: right to left or top to bottom rather
than the default left to right or bottom to top}

\item{grid}{boxpie only: the grid over which the areas are distributed.
Should be roughly equal to the number of areas shown.}

\item{fill}{for spider plots and roc curves: whether to draw filled polygons rather
than lines}

\item{lwd}{Line width to use}

\item{min}{For spider plots: the minimum of the scale on spider plot spikes}

\item{tick.labels}{For spider plots: labels for the scale ticks}
}
\description{
A collection of plotting widgets (pie charts, spider plots etc.)
}
\details{
\if{html}{\figure{overview.svg}{options: width=800 alt="Overview of all widgets"}}
\if{latex}{\figure{overview.pdf}{options: width=5in}}

A widget here is a mini-plot which can be placed anywhere on any other
plot, at an area specified by the center point coordinates x and y, and
width and height. The widgets do not influence the layout of the plot, or change any
parameters with \code{par()}; it only uses basic graphic primitives for
maximal compatibility.

The \code{plotWidget()} function is a generic to call the available
widgets from one place. Any widget-specific parameters are passed on
through the ellipsis (...). See the documentation for specific widgets
for more information. Use the functions \code{\link{listPlotWidgets}}
and \code{\link{plotwidgetGallery}} to see available widgets.

The pie function draws a simple pie chart at specified coordinates with
specified width, height and color. The rug function draws a
corresponding rug plot, while boxpie creates a "rectangular pie
chart" that is considered to be better legible than the regular pie.
}
\section{Functions}{
\itemize{
\item \code{wgPie}: \code{pie()} draws a pie chart with width w and height h at coordinates
(x,y). The angle width of the slices is taken from the numeric vector v, and
their color from the character vector col. Note that one of the main goals of the
plotwidget package is to give sufficient alternatives to pie charts, hoping
to help eradicate pie charts from the surface of this planet.

\item \code{wgRing}: A pie with the center removed.

\item \code{wgPlanets}: Produces a circular arrangement of circles, which
vary in their size proportionally to the values in \code{v}.

\item \code{wgBurst}: Burst plots are similar to pies. However, instead of approximating
numbers by arc length, wgBurst approximates by area, making the pie slices stand
out from the plot in the process.

\item \code{wgRug}: A stacked, horizontal or vertical bar plot.

\item \code{wgBarplot}: A minimalistic bar plot. Use the \code{max}
paramter to scale the bars on several different widgets to the same value.

\item \code{wgBoxpie}: Rectangular pies are thought to represent
information better than pies. Here, the values in v correspond to areas
rather than angles, which makes it easier to interpret it visually.

\item \code{wgRoccurve}: This is one of two wigets that take use a
different data type. \code{wgRoccurve} takes either a vector of T/F
values, or a list of such vectors, and draws a ROC curve for each of these
vectors.

\item \code{wgSpider}: Spider plots can illustrate multivariate data.
Different spikes may illustrate different variables, while different
lines correspond to different samples -- or vice versa. Consequently,
wgSpider accepts either a vector (for a single line) or a matrix (in which
each column will correspond to a single line on the plot). The length of
the vector (or the number of rows in the matrix) corresponds to the number
of spikes on the spider plot.
}}
\examples{
# demonstration of the three widgets
plot.new()
par(usr=c(0,3,0,3))
v <- c(7, 5, 11)
col <- plotPals("safe")
b <- "black"
wgRug(0.5, 1.5, 0.8, 0.8, v=v, col=col, border=b)
wgPie(1.5, 1.5, 0.8, 0.8, v=v, col=col, border=b)
wgBoxpie(2.5, 1.5, 0.8, 0.8, v=v, col=col, border=b)

# using pie as plotting symbol
plot(NULL, xlim=1:2, ylim=1:2, xlab="", ylab="")
col <- c("#cc000099", "#0000cc99")
for(i in 1:125) { 
  x <- runif(1) + 1 
  y <- runif(1) + 1
  wgPie( x, y, 0.05, 0.05, c(x,y), col)
}

# square filled with box pies
n <- 10 
w <- h <- 1/(n+1)
plot.new()
for(i in 1:n) for(j in 1:n) 
 wgBoxpie(x=1/n*(i-1/2), y=1/n*(j-1/2), w, h, 
 v=runif(3), col=plotPals("zeileis"))
}
\seealso{
\code{\link{wgPie}}, \code{\link{wgBoxpie}}, \code{\link{wgSpider}}, \code{\link{wgRug}}, \code{\link{wgBurst}},
         \code{\link{wgRing}}, \code{\link{wgBarplot}}, \code{\link{wgPlanets}}, \code{\link{wgRoccurve}}
}

