% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_describe.R
\name{geom_describe}
\alias{geom_describe}
\title{Description values plot}
\usage{
geom_describe(
  mapping = NULL,
  data = NULL,
  stat = "describe",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  lineend = "round",
  show_error = TRUE,
  center_symbol = "bar",
  center_width = 0.3,
  error_width = 0.2,
  center_func = mean,
  low_func = function(x, na.rm) {
     mean(x, na.rm = na.rm) - sd(x, na.rm = na.rm)
 },
  high_func = function(x, na.rm) {
     mean(x, na.rm = na.rm) + sd(x, na.rm = na.rm)
 },
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{lineend}{Line end style (round, butt, square).}

\item{show_error}{show error symbol}

\item{center_symbol}{one of \verb{point, bar}}

\item{center_width}{if \code{center_symbol='bar'}, the width of the bar}

\item{error_width}{the width of the error bar}

\item{center_func}{the center function, \code{mean} as default}

\item{low_func}{the low error function, \code{mean} minus \code{sd} as default}

\item{high_func}{the high error function, \code{mean} plus \code{sd} as default}

\item{...}{Other arguments passed on to \code{ggplot2::point()} or
\code{ggplot2::geom_segment}.}
}
\value{
\code{ggplot} object
}
\description{
The describe geom is used to create description values plot, including
center symbol and error symbol. The center symbol can be mean, median or
other custom functions, the error symbol can be sd, quantile or other custom
functions.
}
