% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sda.R
\name{getpmddf}
\alias{getpmddf}
\title{Get pmd details for specific reaction after the removal of isotopouge.}
\usage{
getpmddf(mz, group = NULL, pmd = NULL, digits = 2, mdrange = c(0.25, 0.9))
}
\arguments{
\item{mz}{a vector of mass to charge ratio.}

\item{group}{mass to charge ratio group from either retention time or mass spectrometry imaging segmentation.}

\item{pmd}{a specific paired mass distance or a vector of pmds}

\item{digits}{mass or mass to charge ratio accuracy for pmd, default 2.}

\item{mdrange}{mass defect range to ignore. Default c(0.25,0.9) to retain the possible reaction related paired mass.}
}
\value{
dataframe with paired peaks for specific pmd or pmds. When group is provided, a column named net will be generated to show if certain pmd will be local(within the same group) or global(across the groups)
}
\description{
Get pmd details for specific reaction after the removal of isotopouge.
}
\examples{
data(spmeinvivo)
pmddf <- getpmddf(spmeinvivo$mz,pmd=15.99)
}
\seealso{
\code{\link{getpaired}},\code{\link{getstd}},\code{\link{getsda}},\code{\link{getrda}}
}
