% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{as_mcmc}
\alias{as_mcmc}
\title{Return a CODA mcmc object with the required samples}
\usage{
as_mcmc(sampler, selection = "theta_mu", filter = stages)
}
\arguments{
\item{sampler}{The pmwgs object containing samples to extract.}

\item{selection}{The selection of sample types to return.}

\item{filter}{A filter that defines which stage to draw samples from.}
}
\value{
An mcmc object or list containing the selected samples.
}
\description{
Given a sampler object and a specification of the samples required, return
either an individual coda mcmc object, or a list of mcmc objects.
}
\section{Selecting sample types}{


The values that can be chosen for the \code{selection} argument can be one
of the following list:
\describe{
  \item{\code{"theta_mu"}}{the model parameter estimate samples}
  \item{\code{"theta_sig"}}{the covariance matrix estimates, returns a list
    of mcmc objects, one for each model parameter.}
  \item{\code{"alpha"}}{the random effect estimates, returns a list of mcmc
    objects, one for each subject.}
}
The default value for \code{selection} is \code{"theta_mu"}
}

\section{Filtering samples}{


The \code{filter} argument can take one of two forms:
\itemize{
  \item An integer vector, usually a sequence of integers, that must fall
        within the range 1:end.
  \item A character vector, where each element corresponds to a stage of the
        sampling process, i.e. one or more of "init", "burn", "adapt" or
        "sample".
}
The default value for \code{filter} is all stages.
}

\examples{
par_estimates <- as_mcmc(sampled_forstmann)
par_estimates_sample_stage <- as_mcmc(sampled_forstmann, filter = "sample")
rand_eff <- as_mcmc(
  sampled_forstmann,
  selection = "alpha",
  filter = "sample"
)
}
