% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_blq.R
\name{breaks_blq_general}
\alias{breaks_blq_general}
\title{Generate breaks for measurements below the limit of quantification}
\usage{
breaks_blq_general(lloq, breakfun, trans = identity, ...)
}
\arguments{
\item{lloq}{The value of the lower limit of quantification as a numeric
scalar}

\item{breakfun}{The function used for normal scale breaks if the \code{lloq}
were not present.}

\item{trans}{A parameter translation function (typically either
\code{identity} for linear scale or \code{log} for log scale).}

\item{...}{passed as \code{breakfun(n=n, ...)}}
}
\value{
A function for calculating breaks with arguments \code{x} and
\code{n}
}
\description{
Breaks that are \code{< lloq} are removed.  If the lowest break is removed if
it is too close to the lloq.
}
\details{
For ggplot2 scales.  This is not usually used directly.  See
\code{blq_trans()} and \code{blq_log10_trans()} for the functions that are
more commonly used.
}
\examples{
breaks_blq_general(lloq=3, breakfun=scales::breaks_extended)(1:100, n=5)
}
\seealso{
Other BLQ Transformation: 
\code{\link{blq_trans}()},
\code{\link{estimate_lloq}()},
\code{\link{ftrans_blq_linear}()},
\code{\link{itrans_blq_linear}()},
\code{\link{label_blq}()}
}
\concept{BLQ Transformation}
