% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_shrinkage.R
\name{get_shrinkage}
\alias{get_shrinkage}
\title{Extract shrinkage estimates from a NONMEM output object.}
\usage{
get_shrinkage(x, output = "eta", type = "sd", sigdig = 3, est.step = NULL)
}
\arguments{
\item{x}{A NONMEM output object generated using \code{\link{read_nm}}.}

\item{output}{A flag specifying the shrinkage estimates to be output. Valid flag
values are \code{eta} (the default), \code{epsilon}, or \code{all}.}

\item{type}{Specifies the type of shrinkage to report. Valid values are \code{sd}
(standard deviation, the default) or \code{vr} (variance, if present in the XML output).}

\item{sigdig}{Specifies the number of significant digits to be provided (default=3).}

\item{est.step}{Specifies which estimation step to return parameters from (default is the last).}
}
\value{
A named vector of NONMEM shrinkage estimates, or in the case of \code{all},
a list of named vectors.

\code{eta} returns a vector of ETA shrinkages, as reported by NONMEM.
\code{epsilon} returns EPSILON shrinkage, as reported by NONMEM.
\code{all} returns both ETA and EPSILON shrinkage estimates as a list of vectors.
}
\description{
Extract shrinkage estimates from a NONMEM output object.
}
\examples{
\dontrun{
 nmOutput <- read_nm("run315.xml")
 shr <- get_shrinkage(nmOutput, output="all")
}

}
\seealso{
NONMEM (\url{https://www.iconplc.com/solutions/technologies/nonmem})
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
