% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_read_agent.R
\name{yaml_agent_show_exprs}
\alias{yaml_agent_show_exprs}
\title{Display validation expressions using \strong{pointblank} YAML}
\usage{
yaml_agent_show_exprs(filename, path = NULL)
}
\arguments{
\item{filename}{\emph{File name}

\verb{scalar<character>} // \strong{required}

The name of the YAML file that contains fields related to an \emph{agent}.}

\item{path}{#' @param path \emph{File path}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional path to the YAML file (combined with \code{filename}).}
}
\description{
The \code{yaml_agent_show_exprs()} function follows the specifications of a
\strong{pointblank} YAML file to generate and show the \strong{pointblank} expressions
for generating the described validation plan. The expressions are shown in
the console, providing an opportunity to copy the statements and extend as
needed. A \strong{pointblank} YAML file can itself be generated by using the
\code{\link[=yaml_write]{yaml_write()}} function with a pre-existing \emph{agent}, or, it can be carefully
written by hand.
}
\section{Examples}{


Let's create a validation plan for the data quality analysis of the
\code{small_table} dataset. We need an agent and its table-prep formula enables
retrieval of the target table.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <-
  create_agent(
    tbl = ~ small_table,
    tbl_name = "small_table",
    label = "A simple example with the `small_table`.",
    actions = action_levels(
      warn_at = 0.10,
      stop_at = 0.25,
      notify_at = 0.35
    )
  ) \%>\%
  col_exists(columns = c(date, date_time)) \%>\%
  col_vals_regex(
    columns = b,
    regex = "[0-9]-[a-z]\{3\}-[0-9]\{3\}"
  ) \%>\%
  rows_distinct() \%>\%
  col_vals_gt(columns = d, value = 100) \%>\%
  col_vals_lte(columns = c, value = 5)
}\if{html}{\out{</div>}}

The agent can be written to a \strong{pointblank} YAML file with \code{\link[=yaml_write]{yaml_write()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yaml_write(
  agent = agent,
  filename = "agent-small_table.yml"
)
}\if{html}{\out{</div>}}

At a later time, the YAML file can be read into a new agent with the
\code{\link[=yaml_read_agent]{yaml_read_agent()}} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <- yaml_read_agent(filename = "agent-small_table.yml")

agent
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_yaml_agent_show_exprs_1.png" alt="This image was generated from the first code example in the `yaml_agent_show_exprs()` help file." style="width:100\%;">
}
}

To get a sense of which expressions are being used to generate the new agent,
we can use \code{yaml_agent_show_exprs()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yaml_agent_show_exprs(filename = "agent-small_table.yml")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{create_agent(
  tbl = ~small_table,
  actions = action_levels(
    warn_at = 0.1,
    stop_at = 0.25,
    notify_at = 0.35
  ),
  tbl_name = "small_table",
  label = "A simple example with the `small_table`."
) \%>\%
  col_exists(
    columns = c(date, date_time)
  ) \%>\%
  col_vals_regex(
    columns = b,
    regex = "[0-9]-[a-z]\{3\}-[0-9]\{3\}"
  ) \%>\%
  rows_distinct() \%>\%
  col_vals_gt(
    columns = d,
    value = 100
  ) \%>\%
  col_vals_lte(
    columns = c,
    value = 5
  )
}\if{html}{\out{</div>}}
}

\section{Function ID}{

11-6
}

\seealso{
Other pointblank YAML: 
\code{\link{yaml_agent_interrogate}()},
\code{\link{yaml_agent_string}()},
\code{\link{yaml_exec}()},
\code{\link{yaml_informant_incorporate}()},
\code{\link{yaml_read_agent}()},
\code{\link{yaml_read_informant}()},
\code{\link{yaml_write}()}
}
\concept{pointblank YAML}
