% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nationalization.R
\name{nationalization}
\alias{nationalization}
\title{Party Nationalization Index}
\usage{
nationalization(x)
}
\arguments{
\item{x}{(\code{numeric}). A numeric vector with the vote share for a given party x in each electoral district.}
}
\value{
The result of the index is a value between 0 and 1.
A high score indicates a high level of nationalization
}
\description{
`nationalization()` calculates the Party Nationalization Index as proposed by Jones e Mainwaring (2003).
}
\examples{

x <- runif(27, 0.03, 0.2)
nationalization(x)

}
\references{
Jones, M. P., & Mainwaring, S. (2003). The Nationalization of Parties and Party Systems: An Empirical Measure and an Application to the Americas. Party Politics, 9(2), 139–166. https://doi.org/10.1177/13540688030092002
}
