% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{hom_test_polysph}
\alias{hom_test_polysph}
\title{Homogeneity test for several polyspherical samples}
\usage{
hom_test_polysph(X, d, labels, type = c("jsd", "mean", "scatter", "hd")[1],
  h = NULL, kernel = 1, kernel_type = 1, k = 10, B = 1000,
  M = 10000, plot_boot = FALSE, seed_jsd = NULL, cv_jsd = TRUE)
}
\arguments{
\item{X}{a matrix of size \code{c(n, sum(d) + r)} with the sample.}

\item{d}{vector of size \code{r} with dimensions.}

\item{labels}{vector with \code{k} different levels indicating the group.}

\item{type}{kind of test to be performed: \code{"jsd"} (default), a test
comparing the kernel density estimators for \eqn{k} groups using the
Jensen--Shannon distance; \code{"mean"}, a simple test for the equality of
two means (non-omnibus for testing homogeneity); \code{"scatter"}, a simple
test for the equality of two scatter matrices; \code{"hd"}, a test comparing
the kernel density estimators for two groups using the Hellinger distance.}

\item{h}{vector of size \code{r} with bandwidths.}

\item{kernel}{kernel employed: \code{1} for von Mises--Fisher (default);
\code{2} for Epanechnikov; \code{3} for softplus.}

\item{kernel_type}{type of kernel employed: \code{1} for product kernel
(default); \code{2} for spherically symmetric kernel.}

\item{k}{softplus kernel parameter. Defaults to \code{10.0}.}

\item{B}{number of permutations to use. Defaults to \code{1e3}.}

\item{M}{number of Monte Carlo samples to use when approximating the
Hellinger/Jensen--Shannon distance. Defaults to \code{1e4}.}

\item{plot_boot}{flag to display a graphical output of the test decision.
Defaults to \code{FALSE}.}

\item{seed_jsd}{seed for the Monte Carlo simulations used to estimate the
integrals in the Jensen--Shannon distance in the original and bootstrapped
statistics. Defaults to \code{NULL} (no seed is fixed).}

\item{cv_jsd}{use cross-validation to approximate the Jensen--Shannon
distance? Does not require Monte Carlo. Defaults to \code{TRUE}.}
}
\value{
An object of class \code{"htest"} with the following fields:
\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value of the test.}
\item{statistic_perm}{the \code{B} permuted statistics.}
\item{n}{a table with the sample sizes per group.}
\item{h}{bandwidths used.}
\item{B}{number of permutations.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{the kind of test performed.}
\item{data.name}{a character string giving the name of the data.}
}
\description{
Permutation tests for the equality of distributions of two or
\eqn{k} samples of data on \eqn{\mathcal{S}^{d_1} \times \cdots \times
\mathcal{S}^{d_r}}. The Jensen--Shannon distance is used to construct a test
statistic measuring the discrepancy between the \eqn{k} kernel density
estimators. Tests based on the mean and scatter matrices are also available,
but for only two samples (\eqn{k=2}).
}
\details{
Only \code{type = "jsd"} is able to deal with \eqn{k > 2}.

The \code{"jsd"} statistic is the Jensen--Shannon divergence. This statistic
is bounded in \eqn{[0, 1]}. The \code{"mean"} statistic measures the maximum
(chordal) distance between the estimated group means. This statistic is
bounded in \eqn{[0, 1]}. The \code{"scatter"} statistic measures the maximum
affine invariant Riemannian metric between the estimated scatter matrices.
The \code{"hd"} statistic computes a monotonic transformation of the
Hellinger distance, which is the Bhattacharyya divergence (or coefficient).
}
\examples{
## Two-sample case
\donttest{
# H0 holds
n <- c(50, 100)
X1 <- rotasym::r_vMF(n = n[1], mu = c(0, 0, 1), kappa = 1)
X2 <- rotasym::r_vMF(n = n[2], mu = c(0, 0, 1), kappa = 1)
hom_test_polysph(X = rbind(X1, X2), labels = rep(1:2, times = n),
                 d = 2, type = "jsd", h = 0.5)

# H0 does not hold
X2 <- rotasym::r_vMF(n = n[2], mu = c(0, 1, 0), kappa = 2)
hom_test_polysph(X = rbind(X1, X2), labels = rep(1:2, times = n),
                 d = 2, type = "jsd", h = 0.5)

## k-sample case

# H0 holds
n <- c(50, 100, 50)
X1 <- rotasym::r_vMF(n = n[1], mu = c(0, 0, 1), kappa = 1)
X2 <- rotasym::r_vMF(n = n[2], mu = c(0, 0, 1), kappa = 1)
X3 <- rotasym::r_vMF(n = n[3], mu = c(0, 0, 1), kappa = 1)
hom_test_polysph(X = rbind(X1, X2, X3), labels = rep(1:3, times = n),
                 d = 2, type = "jsd", h = 0.5)

# H0 does not hold
X3 <- rotasym::r_vMF(n = n[3], mu = c(0, 1, 0), kappa = 2)
hom_test_polysph(X = rbind(X1, X2, X3), labels = rep(1:3, times = n),
                 d = 2, type = "jsd", h = 0.5)
}
}
