% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI-wrap.R
\name{DBI-wrap}
\alias{DBI-wrap}
\alias{dbDataType,Pool-method}
\alias{dbGetQuery,Pool,ANY-method}
\alias{dbExecute,Pool,ANY-method}
\alias{dbListFields,Pool,ANY-method}
\alias{dbListTables,Pool-method}
\alias{dbListObjects,Pool-method}
\alias{dbReadTable,Pool,ANY-method}
\alias{dbWriteTable,Pool,ANY-method}
\alias{dbCreateTable,Pool-method}
\alias{dbAppendTable,Pool-method}
\alias{dbExistsTable,Pool,ANY-method}
\alias{dbRemoveTable,Pool,ANY-method}
\alias{dbIsReadOnly,Pool-method}
\alias{sqlData,Pool-method}
\alias{sqlCreateTable,Pool-method}
\alias{sqlAppendTable,Pool-method}
\alias{sqlInterpolate,Pool-method}
\alias{sqlParseVariables,Pool-method}
\alias{dbQuoteIdentifier,Pool,ANY-method}
\alias{dbUnquoteIdentifier,Pool-method}
\alias{dbQuoteLiteral,Pool-method}
\alias{dbQuoteString,Pool,ANY-method}
\alias{dbAppendTableArrow,Pool-method}
\alias{dbCreateTableArrow,Pool-method}
\alias{dbGetQueryArrow,Pool-method}
\alias{dbReadTableArrow,Pool-method}
\alias{dbSendQueryArrow,Pool-method}
\alias{dbWriteTableArrow,Pool-method}
\title{DBI methods (simple wrappers)}
\usage{
\S4method{dbDataType}{Pool}(dbObj, obj, ...)

\S4method{dbGetQuery}{Pool,ANY}(conn, statement, ...)

\S4method{dbExecute}{Pool,ANY}(conn, statement, ...)

\S4method{dbListFields}{Pool,ANY}(conn, name, ...)

\S4method{dbListTables}{Pool}(conn, ...)

\S4method{dbListObjects}{Pool}(conn, prefix = NULL, ...)

\S4method{dbReadTable}{Pool,ANY}(conn, name, ...)

\S4method{dbWriteTable}{Pool,ANY}(conn, name, value, ...)

\S4method{dbCreateTable}{Pool}(conn, name, fields, ..., row.names = NULL, temporary = FALSE)

\S4method{dbAppendTable}{Pool}(conn, name, value, ..., row.names = NULL)

\S4method{dbExistsTable}{Pool,ANY}(conn, name, ...)

\S4method{dbRemoveTable}{Pool,ANY}(conn, name, ...)

\S4method{dbIsReadOnly}{Pool}(dbObj, ...)

\S4method{sqlData}{Pool}(con, value, row.names = NA, ...)

\S4method{sqlCreateTable}{Pool}(con, table, fields, row.names = NA, temporary = FALSE, ...)

\S4method{sqlAppendTable}{Pool}(con, table, values, row.names = NA, ...)

\S4method{sqlInterpolate}{Pool}(conn, sql, ..., .dots = list())

\S4method{sqlParseVariables}{Pool}(conn, sql, ...)

\S4method{dbQuoteIdentifier}{Pool,ANY}(conn, x, ...)

\S4method{dbUnquoteIdentifier}{Pool}(conn, x, ...)

\S4method{dbQuoteLiteral}{Pool}(conn, x, ...)

\S4method{dbQuoteString}{Pool,ANY}(conn, x, ...)

\S4method{dbAppendTableArrow}{Pool}(conn, name, value, ...)

\S4method{dbCreateTableArrow}{Pool}(conn, name, value, ..., temporary = FALSE)

\S4method{dbGetQueryArrow}{Pool}(conn, statement, ...)

\S4method{dbReadTableArrow}{Pool}(conn, name, ...)

\S4method{dbSendQueryArrow}{Pool}(conn, statement, ...)

\S4method{dbWriteTableArrow}{Pool}(conn, name, value, ...)
}
\arguments{
\item{dbObj}{A DBI Driver][DBI::DBIDriver-class] or
\link[DBI:DBIConnection-class]{DBI Connection}.}

\item{obj}{An R object whose SQL type we want to determine.}

\item{...}{Other arguments passed on to methods.}

\item{conn}{A \link[DBI:DBIConnection-class]{DBI Connection}.}

\item{statement}{a character string containing SQL.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{prefix}{A fully qualified path in the database's namespace, or \code{NULL}.
This argument will be processed with \code{\link[DBI:dbUnquoteIdentifier]{dbUnquoteIdentifier()}}.
If given the method will return all objects accessible through this prefix.}

\item{value}{A \link{data.frame} (or coercible to data.frame).}

\item{fields}{Either a character vector or a data frame.

A named character vector: Names are column names, values are types.
Names are escaped with \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}.
Field types are unescaped.

A data frame: field types are generated using
\code{\link[DBI:dbDataType]{dbDataType()}}.}

\item{row.names}{Must be \code{NULL}.}

\item{temporary}{If \code{TRUE}, will generate a temporary table.}

\item{con}{A database connection.}

\item{table}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{values}{A data frame. Factors will be converted to character vectors.
Character vectors will be escaped with \code{\link[DBI:dbQuoteString]{dbQuoteString()}}.}

\item{sql}{A SQL string containing variables to interpolate.
Variables must start with a question mark and can be any valid R
identifier, i.e. it must start with a letter or \code{.}, and be followed
by a letter, digit, \code{.} or \verb{_}.}

\item{.dots}{A list of named arguments to interpolate.}

\item{x}{A character vector, \link[DBI]{SQL} or \link[DBI]{Id} object to quote as identifier.}
}
\description{
These pool method for DBI generics methods check out a connection
(with \code{\link[=poolCheckout]{poolCheckout()}}), re-call the generic, then return the connection
to the pool (with \code{\link[=poolReturn]{poolReturn()}}).
See \link{DBI-custom} for DBI methods that do not work with pool objects.
}
\examples{
mtcars1 <- mtcars[ c(1:16), ] # first half of the mtcars dataset
mtcars2 <- mtcars[-c(1:16), ] # second half of the mtcars dataset

pool <- dbPool(RSQLite::SQLite())

# write the mtcars1 table into the database
dbWriteTable(pool, "mtcars", mtcars1, row.names = TRUE)

# list the current tables in the database
dbListTables(pool)

# read the "mtcars" table from the database (only 16 rows)
dbReadTable(pool, "mtcars")

# append mtcars2 to the "mtcars" table already in the database
dbWriteTable(pool, "mtcars", mtcars2, row.names = TRUE, append = TRUE)

# read the "mtcars" table from the database (all 32 rows)
dbReadTable(pool, "mtcars")

# get the names of the columns in the databases's table
dbListFields(pool, "mtcars")

# use dbExecute to change the "mpg" and "cyl" values of the 1st row
dbExecute(pool,
  paste(
    "UPDATE mtcars",
    "SET mpg = '22.0', cyl = '10'",
    "WHERE row_names = 'Mazda RX4'"
  )
)

# read the 1st row of "mtcars" table to confirm the previous change
dbGetQuery(pool, "SELECT * FROM mtcars WHERE row_names = 'Mazda RX4'")

# drop the "mtcars" table from the database
dbRemoveTable(pool, "mtcars")

# list the current tables in the database
dbListTables(pool)

poolClose(pool)
}
