% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Moultrie.R
\name{Moultrie}
\alias{Moultrie}
\title{Moultrie rule for Children Ever Born}
\usage{
Moultrie(data, ...)
}
\arguments{
\item{data}{data.drame. It contains at least three variables: five-year grouped ages, number of childs and Children Ever Born (CEB).}

\item{...}{Arguments to be passed to \code{dplyr::select}, i.e., five-year grouped ages, number of childs and Children Ever Born.}
}
\value{
\code{Moultrie} returns a data.frame with corrected childs for each number of Children Ever Born and five-year grouped ages.
}
\description{
Moultrie's proposal for correction of Children Ever Born in five-year grouped ages.
}
\examples{

CEB_data <- tidyr::gather(CEB, ages, childs, -Children_Ever_Born)
results <- Moultrie(CEB_data, ages, childs, Children_Ever_Born)
tidyr::pivot_wider(results, names_from=age, values_from=childs)


}
\references{
\insertRef{moultrie}{popstudy}
}
\seealso{
\code{CEB} dataset
\code{El_Badry} dataset
}
\author{
Cesar Gamboa-Sanabria
}
