% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_classes.R
\docType{class}
\name{portvine_roll-class}
\alias{portvine_roll-class}
\alias{cond_portvine_roll-class}
\alias{show,portvine_roll-method}
\alias{show,cond_portvine_roll-method}
\alias{summary,portvine_roll-method}
\alias{summary,cond_portvine_roll-method}
\title{S4 output class for the function \code{estimate_risk_roll()}}
\usage{
\S4method{show}{portvine_roll}(object)

\S4method{show}{cond_portvine_roll}(object)

\S4method{summary}{portvine_roll}(object)

\S4method{summary}{cond_portvine_roll}(object)
}
\arguments{
\item{object}{An object of class \code{portvine_roll} or \code{cond_portvine_roll}}
}
\value{
object of class \code{portvine_roll}

object of class \code{cond_portvine_roll}
}
\description{
The main output class for the function \code{\link[=estimate_risk_roll]{estimate_risk_roll()}}is
\code{portvine_roll} but in the conditional case
the child class \code{cond_portvine_roll} with some extra slots (below visible
by the !C!) is returned.
}
\details{
For easy access for the most important slots and some filtering functionality
have a look at the accessor methods \code{\link[=risk_estimates]{risk_estimates()}}, \code{\link[=fitted_vines]{fitted_vines()}},
\code{\link[=fitted_marginals]{fitted_marginals()}}.
}
\section{Slots}{

\describe{
\item{\code{risk_estimates}}{data.table with the columns \code{risk_measure},
\code{risk_est}, \code{alpha}, \code{row_num}, \code{vine_window} and \code{realized} (here all
samples also in the conditional case are used)}

\item{\code{fitted_marginals}}{named list with an entry for each asset containing a
\code{\link[rugarch:ugarchroll-methods]{rugarch::ugarchroll}} class object that encompasses the marginal model fit.}

\item{\code{fitted_vines}}{list of \code{\link[rvinecopulib:vinecop]{rvinecopulib::vinecop}} class objects each entry
corresponds to one vine window.}

\item{\code{marginal_settings}}{containing the specification used for the ARMA-GARCH
fitting i.e. marginal models. Is of class \code{marginal_settings}.}

\item{\code{vine_settings}}{containing the specifications used for the vine fitting.
Is of class \code{vine_settings}.}

\item{\code{risk_measures}}{a character vector displaying the estimated risk
measures.}

\item{\code{alpha}}{numeric vector in (0,1) displaying the confidence levels used
when estimating the risk measures.}

\item{\code{weights}}{the numeric positive weights of the assets. (Matrix with each
row corresponding to one vine window) The weights of conditional variables
are always 0.}

\item{\code{cond_estimation}}{logical value indicating whether the conditional
estimation approach for the risk measures was used.}

\item{\code{n_samples}}{positive numeric count displaying how many return samples
were used for the risk measure estimation.}

\item{\code{time_taken}}{numeric value displaying how many minutes the whole
estimation process took.}

\item{\code{cond_risk_estimates}}{!C! data.table with the same columns as the
\code{risk_estimate} slot has + the additional conditional columns with the
respective conditioning value and the column character \code{cond_u} that
indicates the used conditional quantile level or the conditional value
corresponding to the residual one time unit prior with "prior_resid" or
the realized residual with "resid".}

\item{\code{cond_vars}}{!C! character vector with the names of the variables that
were used to sample conditionally from.}

\item{\code{cond_u}}{!C! a numeric vector specifying the corresponding quantiles
in (0,1) of the conditional variable(s) conditioned on which the conditional
risk measures were calculated.}
}}

\seealso{
\code{\link[=estimate_risk_roll]{estimate_risk_roll()}}, \code{\link[=risk_estimates]{risk_estimates()}}, \code{\link[=fitted_vines]{fitted_vines()}},
\code{\link[=fitted_marginals]{fitted_marginals()}}
}
