% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_remove.R
\name{post_remove}
\alias{post_remove}
\title{Remove nodes from mcmc.list}
\usage{
post_remove(post, params, ask = TRUE, auto_escape = TRUE)
}
\arguments{
\item{post}{A \code{\link[coda:mcmc.list]{mcmc.list}} object.}

\item{params}{A vector of regular expressions specifying the nodes to match for removal.
Accepts multi-element vectors to match more than one node at a time.
See \code{\link[=match_params]{match_params()}} and \code{vignette("pattern-matching")} for more details.}

\item{ask}{Prompt user for a response prior to removing nodes?}

\item{auto_escape}{Automatically escape \code{"["} and \code{"]"} characters?
See \code{\link[=match_params]{match_params()}} for details.}
}
\value{
A \code{\link[coda:mcmc.list]{mcmc.list}}, identical in all ways to the original
except that nodes matched by the \code{params} argument are removed. If the user
responds "no" to the question when \code{ask = TRUE}, \code{post} is returned unaltered.
}
\description{
Just like \code{\link[=post_subset]{post_subset()}}, but keep all nodes \strong{except} those that match.
}
\examples{
# load example mcmc.list
data(cjs)

# get names of all nodes
get_params(cjs)

# remove the SIG nodes
new_cjs = suppressMessages(post_remove(cjs, "SIG", ask = FALSE))

# get names of new output
get_params(new_cjs)
}
