% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmAll.R
\name{genTrees}
\alias{genTrees}
\title{Generation of rooted binary trees under a given tree model}
\usage{
genTrees(n, Ntrees = 1L, tm)
}
\arguments{
\item{n}{Integer value that specifies the desired number of leaves, i.e.,
vertices with in-degree 1 and out-degree 0. \cr
Due to the restrictions of the \code{phylo} or \code{multiPhylo} format,
the number of leaves must be at least 2 since there
must be at least one edge.}

\item{Ntrees}{Integer value (default = 1) that specifies the desired number
of generated trees.}

\item{tm}{Character or list specifying the tree model under which the trees
should be generated as well as their parameters. Available are: \cr
\itemize{
\item \code{"yule"} - Yule model. \cr
\item \code{"pda"} - PDA model. \cr
\item \code{"etm"} - ETM. \cr
\item \code{list("aldous", BETA)} - Aldous' beta splitting model with parameter
\code{BETA} >= -2. \cr
\item \code{list("ford", ALPHA)} - Ford's alpha model with parameter
\code{ALPHA} >= 0 and <= 1. \cr
\item \code{list("alt-birth-death", BIRTHRATE, DEATHRATE)} or \cr
\code{list("alt-birth-death", BIRTHRATE, DEATHRATE, TRIES)} -
Alternative birth-death model with parameters \code{BIRTHRATE} >0 and
\code{DEATHRATE}>= 0. \cr
\item \code{list("density", BIRTHRATE, EQUILIB)} or \cr
\code{list("density", BIRTHRATE, EQUILIB, TRIES, TIMEperTRY)} -
Density dependent model with parameters \code{BIRTHRATE} >0 and
\code{EQULIB}>= 1. \cr
\item \code{list("BiSSE", BIRTHRATES, DEATHRATES, TRANSRATES)} or \cr
\code{list("BiSSE", BIRTHRATES, DEATHRATES, TRANSRATES, TRIES, TIMEperTRY)} -
BiSSE model with parameters \code{BIRTHRATES} (vector with 2 values >=0, one
value >0),
\code{DEATHRATES} (vector with 2 values >=0), and
\code{TRANSRATES} (vector with 2 values >=0, one
value >0). \cr
\item \code{list("DCO_sym", ZETA)} or \cr
\code{list("DCO_sym", ZETA, STARTING_RATE)} - Symmetric direct-children-only
with parameter \code{ZETA} > 0 and optionally \code{STARTING_RATE} > 0
(default = 1). \cr
\item \code{list("DCO_asym", ZETA)} or \cr
\code{list("DCO_asym", ZETA, STARTING_RATE)} - Asymmetric
direct-children-only with parameter \code{ZETA} > 0 and optionally
\code{STARTING_RATE} > 0
(default = 1). \cr
\item \code{list("IF_sym", ZETA)} or \cr
\code{list("IF_sym", ZETA, STARTING_RATE)} - Symmetric inherited fertility
with parameter \code{ZETA} > 0 and optionally \code{STARTING_RATE} > 0
(default = 1). \cr
\item \code{list("IF_asym", ZETA)} or \cr
\code{list("IF_asym", ZETA, STARTING_RATE)} - Asymmetric inherited fertility
with parameter \code{ZETA} > 0 and optionally \code{STARTING_RATE} > 0
(default = 1). \cr
\item \code{list("IF-diff", ZETA)} or \cr
\code{list("IF-diff", ZETA, STARTING_RATE)} - Unequal fertility inheritance
with parameter \code{ZETA} >= 1 and optionally \code{STARTING_RATE} > 0
(default = 1). \cr
\item \code{list("biased", ZETA)} or \cr
\code{list("biased", ZETA, STARTING_RATE)} - Biased speciation
with parameter \code{ZETA} >=0 and <=1 and optionally
\code{STARTING_RATE} > 0 (default = 1). \cr
\item \code{list("ASB", ZETA)} or \cr
\code{list("ASB", ZETA, STARTING_RATE)} - Age-step-based fertility
with parameter \code{ZETA} > 0 and optionally \code{STARTING_RATE} > 0
(default = 1). \cr
\item \code{list("simpleBrown_sym", SIGMA)} or \cr
\code{list("simpleBrown_sym", SIGMA, STARTING_RATE)} - Symmetric simple
Brownian with parameter \code{SIGMA} >= 0 and optionally
\code{STARTING_RATE} > 0 (default = 1). \cr
\item \code{list("simpleBrown_asym", SIGMA)} or \cr
\code{list("simpleBrown_asym", SIGMA, STARTING_RATE)} - Asymmetric simple
Brownian with parameter \code{SIGMA} >= 0 and optionally
\code{STARTING_RATE} > 0 (default = 1). \cr
\item \code{list("lin-Brown_sym", SIGMA)} or \cr
\code{list("lin-Brown_sym", SIGMA, STARTING_RATE, STARTING_TRAIT)} - Sym.
punctuated(-intermittent) linear-Brownian with parameter
\code{SIGMA} (vector with 2 values >=0) and optionally
\code{STARTING_RATE} > 0 (default = 1) and \code{STARTING_TRAIT}
(default = 10). \cr
\item \code{list("lin-Brown_asym", SIGMA)} or \cr
\code{list("lin-Brown_asym", SIGMA, STARTING_RATE, STARTING_TRAIT)} - Asym.
punctuated(-intermittent) linear-Brownian with parameter
\code{SIGMA} (vector with 2 values >=0) and optionally
\code{STARTING_RATE} > 0 (default = 1) and \code{STARTING_TRAIT}
(default = 10). \cr
\item \code{list("lin-Brown-bounded_sym", SIGMA)} or \cr
\code{list("lin-Brown-bounded_sym", SIGMA, STARTING_RATE, STARTING_TRAIT)} -
Bounded sym. punctuated(-intermittent) linear-Brownian with parameter
\code{SIGMA} (vector with 2 values >=0) and optionally
\code{STARTING_RATE} > 0 (default = 1) and \code{STARTING_TRAIT}
(default = 10). \cr
\item \code{list("lin-Brown-bounded_asym", SIGMA)} or \cr
\code{list("lin-Brown-bounded_asym", SIGMA, STARTING_RATE, STARTING_TRAIT)} -
Bounded asym. punctuated(-intermittent) linear-Brownian with parameter
\code{SIGMA} (vector with 2 values >=0) and optionally
\code{STARTING_RATE} > 0 (default = 1) and \code{STARTING_TRAIT}
(default = 10). \cr
\item \code{list("log-Brown_sym", SIGMA)} or \cr
\code{list("log-Brown_sym", SIGMA, STARTING_RATE, STARTING_TRAIT)} - Sym.
punctuated(-intermittent) log-Brownian with parameter
\code{SIGMA} (vector with 2 values >=0) and optionally
\code{STARTING_RATE} > 0 (default = 1) and \code{STARTING_TRAIT}
(default = 10). \cr
\item \code{list("log-Brown_asym", SIGMA)} or \cr
\code{list("log-Brown_asym", SIGMA, STARTING_RATE, STARTING_TRAIT)} - Asym.
punctuated(-intermittent) log-Brownian with parameter
\code{SIGMA} (vector with 2 values >=0) and optionally
\code{STARTING_RATE} > 0 (default = 1) and \code{STARTING_TRAIT}
(default = 10). \cr\cr
More information on each model and their parameters can be found in the
description of each model, accessible with \code{?genYuleTree},
\code{?genPDATree}, \code{?genETMTree}, \code{?genAldousBetaTree},
\code{?genFordsAlphaTree}, \cr \code{?genBirthDeathTree},
\code{?genAltBirthDeathTree}, \code{?genGrowTree}.
}}
}
\value{
\code{genTrees}   If \code{Ntrees} is 1, then a single tree of
class \code{phylo} is returned.
If \code{Ntrees} is larger than 1, a list of class
\code{multiPhylo} containing the trees of class \code{phylo} is returned.
}
\description{
\code{genTrees} - Is a wrapper function that generates
\code{Ntrees}-many rooted binary trees with the given number of \code{n}
leaves under any tree model \code{tm} contained in this package (more
details on the available models are given in the parameter information
for \code{tm}).
}
\examples{
genTrees(n = 5, Ntrees = 2, tm = list("aldous", 1))
genTrees(n = 5, tm = "pda")
}
\references{
\itemize{
\item S. J. Kersting, K. Wicke, and M. Fischer. Tree balance in phylogenetic models.
arXiv:2406.05185, 2024.
\item S. J. Kersting, K. Wicke, and M. Fischer. Tree balance in phylogenetic
models: Supplementary material. https://tinyurl.com/278cwdh8, 2024.
}
}
