% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{generate_kfold_indices}
\alias{generate_kfold_indices}
\title{Generate K-fold Indices for Cross-Validation}
\usage{
generate_kfold_indices(N, Kfold, reverse = FALSE)
}
\arguments{
\item{N}{Integer. Total sample size (number of observations).}

\item{Kfold}{Integer. The number of folds to split the data into.}

\item{reverse}{Logical. Whether to reverse the remainder indices when `N` is not divisible by `Kfold`. Defaults to `FALSE`.}
}
\value{
A vector of length `N` containing the fold assignments (from 1 to `Kfold`).
}
\description{
This function generates indices for K-fold cross-validation based on the total sample size `N` and the number of folds `Kfold`.
If `reverse = TRUE`, the remainder indices will be assigned in reverse order.
}
\author{
Thomas Debray
}
