% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqbinom.R
\name{rqbinom}
\alias{rqbinom}
\title{Sampling of overdispersed binomial data with constant overdispersion}
\usage{
rqbinom(n, size, prob, phi)
}
\arguments{
\item{n}{defines the number of clusters (\eqn{i})}

\item{size}{integer vector defining the number of trials per cluster (\eqn{n_i})}

\item{prob}{probability of success on each trial (\eqn{\pi})}

\item{phi}{dispersion parameter (\eqn{\Phi})}
}
\value{
a \code{data.frame} with two columns (succ, fail)
}
\description{
rqbinom samples overdispersed binomial data with constant overdispersion from
the beta-binomial distribution such that the quasi-binomial assumption is fulfilled.
}
\details{
It is assumed that the dispersion parameter (\eqn{\Phi})
is constant for all \eqn{i=1, ... I} clusters, such that the variance becomes
\deqn{var(y_i)=\Phi n_i \pi (1-\pi).}
For the sampling \eqn{(a+b)_i} is defined as
\deqn{(a+b)_i=(\Phi-n_i)/(1-\Phi)}
where \eqn{a_i=\pi (a+b)_i} and \eqn{b_i=(a+b)_i-a_i}. Then, the binomial proportions
for each cluster are sampled from the beta distribution
\deqn{\pi_i \sim Beta(a_i, b_i)}
and the numbers of success for each cluster are sampled to be
\deqn{y_i \sim Bin(n_i, \pi_i).}
In this parametrization \eqn{E(\pi_i)=\pi} and \eqn{E(y_i)=n_i \pi}.
Please note, the quasi-binomial assumption is not in contradiction with
the beta-binomial distribution if all cluster sizes are the same.
}
\examples{
# Sampling of example data
set.seed(456)
qb_dat1 <- rqbinom(n=10, size=50, prob=0.1, phi=3)
qb_dat1

set.seed(456)
qb_dat2 <- rqbinom(n=3, size=c(40, 50, 60), prob=0.1, phi=3)
qb_dat2


}
