% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{prep.deseason.differencing}
\alias{prep.deseason.differencing}
\title{Deseason with differencing method}
\usage{
prep.deseason.differencing(tserie, nsd = NULL)
}
\arguments{
\item{tserie}{a \code{ts} object}

\item{nsd}{number of seasonal differences to apply. As default its value is NULL; in this case, the function will perform an automatic estimation of \code{nsd}.}
}
\value{
A list is returned containing:
\item{tserie}{Transformed ts object.}
\item{nsd}{Number of seasonal differencies applied.}
\item{firstseasons}{Lost values after differencing.}
}
\description{
Performs differencing with lag=frequency.
}
\details{
If no number of differences is specified, the function will make an estimation
of the number of differences needed based on unit root test provided by \code{forecast::nsdiffs}
}
\examples{
prep.deseason.differencing(AirPassengers)
prep.deseason.differencing(AirPassengers,nsd=2)
}
