% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preferences.R
\name{preferences}
\alias{preferences}
\alias{long_preferences}
\alias{wide_preferences}
\alias{as_preferences}
\alias{format.preferences}
\alias{levels.preferences}
\title{Preferences Objects}
\usage{
long_preferences(
  data,
  col,
  id_cols = NULL,
  rank_col = NULL,
  item_col = NULL,
  item_names = NULL,
  verbose = TRUE,
  unused_fn = NULL,
  na_action = c("drop_rows", "drop_preferences"),
  ...
)

wide_preferences(
  data,
  col = NULL,
  ranking_cols = NULL,
  verbose = TRUE,
  na_action = c("keep_as_partial", "drop_preferences"),
  ...
)

as_preferences(strings, sep = ">", equality = "=", descending = TRUE)

preferences(
  strings = character(0L),
  sep = ">",
  equality = "=",
  descending = TRUE
)

\method{format}{preferences}(x, ...)

\method{levels}{preferences}(x, ...)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble} to extract preferences from}

\item{col}{The name of the new column, as a string or symbol.}

\item{id_cols}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> The columns by which to
group the dataset to extract a single preference selection.}

\item{rank_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> For \code{data} in
long-format: the column representing the rank for the associated item.}

\item{item_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> For \code{data} in
long-format: the column representing the items by name or by index, in which
case the \code{item_names} parameter should also be passed.}

\item{item_names}{The names of the full set of items. This is necessary when
the dataset specifies items by index rather than by name, or when there are
items which do not appear in any preference selection.}

\item{verbose}{If \code{TRUE}, diagnostic messages will be sent to stdout.}

\item{unused_fn}{When \code{format="long"}, summarise the values of unused columns (those
which are not specified by \code{id_cols}, \code{item_col}, or \code{rank_col}). The default action
is to drop all unused columns.
This can be a named list (e.g. \verb{list(column = function)}) if you want to apply different
summaries for different columns or keep only specific unused columns, or it can be a
single function to be applied across all unused columns.}

\item{na_action}{Specifies how to handle NA values.
\describe{
\item{\code{long_preferences}}{
\describe{
\item{\code{"drop_rows"}}{Removes individual rows containing NA values before processing}
\item{\code{"drop_preferences"}}{Removes the entire preference selection that contains any NA}
}
}
\item{\code{wide_preferences}}{
\describe{
\item{\code{"keep"}}{Interprets rows containing NAs as partial orderings}
\item{\code{"drop"}}{Removes preferences with any NA ranks}
}
}
}}

\item{...}{Unused.}

\item{ranking_cols}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> The columns from which
to extract wide-format preferences.}

\item{strings}{A character vector of preference strings}

\item{sep}{Character separating the items in the string (default: ">")}

\item{equality}{Character representing equality between items (default: "=")}

\item{descending}{If TRUE, parse as descending order preferences.}

\item{x}{A vector of preferences.}

\item{format}{The format of the data: one of "ordering", "ranking", or
"long" (see above). By default, \code{data} is assumed to be in "long" format.}
}
\value{
A \code{preferences} object, or a modified tibble with a column of \code{preferences} when \code{data} is
a \code{data.frame} or \code{tibble}.
}
\description{
A tidy interface for working with ordinal preferences.
}
\examples{
# Votes cast by two animals ranking a variety of fruits and vegetables.
# This is not real data, I made this up.
x <- tibble::tribble(
  ~voter_id, ~species, ~food, ~ranking,
  1, "Rabbit", "Apple", 1,
  1, "Rabbit", "Carrot", 2,
  1, "Rabbit", "Banana", 3,
  2, "Monkey", "Banana", 1,
  2, "Monkey", "Apple", 2,
  2, "Monkey", "Carrot", 3
)
# Process preferencial data into a single column.
x |>
  long_preferences(
    food_preference,
    id_cols = voter_id,
    item_col = food,
    rank_col = ranking
  )
# The same, but keep the species data.
x |>
  long_preferences(
    food_preference,
    id_cols = voter_id,
    item_col = food,
    rank_col = ranking,
    unused_fn = list(species = dplyr::first)
  )
}
