% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator.R
\name{prevedere_correlation}
\alias{prevedere_correlation}
\title{Correlation}
\usage{
prevedere_correlation(key, endog_provider, endog_provider_id,
  exog_provider, exog_provider_id, freq = prevedere_frequencies(key),
  calculation = prevedere_calculations(key), raw = FALSE)
}
\arguments{
\item{key}{A Prevedere API key.}

\item{endog_provider}{Code for the data provider of the endogenous indicator,
can be hexadecimal or abbreviated name.}

\item{endog_provider_id}{Specific ProviderID for the endogenous indicator.}

\item{exog_provider}{Code for the data provider of the exogenous indicator,
can be hexadecimal or abbreviated name.}

\item{exog_provider_id}{Specific ProviderID for the exogenous indicator.}

\item{freq}{Frequency of indicator to retrieve. For a list of supported
frequencies, see \code{\link[=prevedere_frequencies]{prevedere_frequencies()}}.}

\item{calculation}{Calculation to transform the indicator. For a list of
supported calculations, see \code{\link[=prevedere_calculations]{prevedere_calculations()}}.}

\item{raw}{Logical value indicating if data should be returned in its raw form
(typically nested lists) or formatted as appropriate, usually a dataframe.}
}
\value{
Model results and metadata, as a list.
}
\description{
Calculates Pearson's r and other statistics at different offsets between an
endogenous and exogenous indicator.
}
\examples{
\dontrun{
k <- "1235467abcdefg"

prevedere_correlation(
  key = k, endog_provider = "BLS", endog_provider_id = "CES3133231058",
  exog_provider = "FRED", exog_provider_id = "PCU332313332313", freq = "Monthly",
  calculation = "ThreePeriodMoving"
)
}
}
\seealso{
Other indicator functions: \code{\link{prevedere_indicator}}
}
\concept{indicator functions}
