% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator.R
\name{prevedere_indicator}
\alias{prevedere_indicator}
\alias{prevedere_indicator_series}
\title{Indicators}
\usage{
prevedere_indicator(key, provider, provider_id)

prevedere_indicator_series(key, provider, provider_id,
  freq = prevedere_frequencies(key),
  calculation = prevedere_calculations(key), start_date = NULL,
  end_date = NULL, offset_periods = 0, raw = FALSE)
}
\arguments{
\item{key}{A Prevedere API key.}

\item{provider}{Code for a data provider, can be hexadecimal or abbreviated
name.}

\item{provider_id}{Specific ProviderID for the indicator.}

\item{freq}{Frequency of indicator to retrieve. For a list of supported
frequencies, see \code{\link[=prevedere_frequencies]{prevedere_frequencies()}}.}

\item{calculation}{Calculation to transform the indicator. For a list of
supported calculations, see \code{\link[=prevedere_calculations]{prevedere_calculations()}}.}

\item{start_date, end_date}{Start and end dates for the indicator. Each should be
either a date or a character string capable of being coerced to a date.
Setting a date to \code{NULL} will result in the historical data being unbounded
in that direction.}

\item{offset_periods}{Number of periods to offset.}

\item{raw}{Logical value indicating if data should be returned in its raw form
(typically nested lists) or formatted as appropriate, usually a dataframe.}
}
\value{
A list. prevedere_indicator returns metadata for
the target indicator, while prevedere_indicator_series returns the actual
data for the indicator (in addition to the metadata).
}
\description{
Access indicator data and metadata.
}
\examples{
\dontrun{

k <- "1235467abcdefg"

## Return indicator metadata
prevedere_indicator(key = k, provider = "BLS", provider_id = "CES3133231058")

## Return indicator data
prevedere_indicator_series(
  key = k, provider = "BLS", provider_id = "CES3133231058",
  freq = "Monthly", calculation = "None", start_date = "2010-01-01",
  offset_periods = 0
)

## Return indicator data unformatted
prevedere_indicator_series(
  key = k, provider = "BLS", provider_id = "CES3133231058",
  freq = "Monthly", calculation = "None", start_date = "2010-01-01",
  offset_periods = 0, raw = TRUE
)
}

}
\seealso{
Other indicator functions: \code{\link{prevedere_correlation}}
}
\concept{indicator functions}
