% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationsfunctions.R
\name{simulate_pps_fast}
\alias{simulate_pps_fast}
\title{Faster method to generate data for PPS with only length of nosocomial infections as output}
\usage{
simulate_pps_fast(n.sample, P, dist.X.loi, dist.X.los = NA,
  one.factor.loi = 1, one.factor.los = 1)
}
\arguments{
\item{n.sample}{number of beds to simulate}

\item{P}{prevalence of nosocomial infections}

\item{dist.X.loi}{vector of probabilities for values 1:length(dist.X.loi) of X.loi}

\item{dist.X.los}{vector of probabilities for values 1:length(dist.X.los) of X.los}

\item{one.factor.loi}{factor by which to approx. reduce number of one day observations for A.loi}

\item{one.factor.los}{factor by which to approx. reduce number of one day observations for A.los}
}
\value{
data frame with a row for a each simulated patient and  the following columns 
\itemize{ 
   \item{A.loi - length of infection up to PPS}
   \item{L.loi - total length of infection}  
   \item{A.los - length of stay up to PPS} 
   \item{L.los - total length of stay} 
   \item{patient.type - patient type (fixed to 1 for fast method)}
}
}
\description{
The function `simulate_pps_fast` can be used to generate PPS data.
This functions simulates a PPS on the basis of a given prevalence `P` using
a vector of probabilities `dist.X.loi` for the values 1:length(dist.X.loi) of X.loi.
It directly samples the time of infection up to date based on `dist.X.loi`.
Optionally, the length of stay is sampled independently ( treating the marginal
distributions of length of stay and length of infection as independent
by assumption) using `dist.X.los` which is in the same format as `dist.X.loi`. 
Because of this non-joint sampling rows should not be interpreted as individual 
patients.
}
\examples{
example.dist <- create_dist_vec(function(x) dpois(x-1, 7), 70)
data.pps.fast <- simulate_pps_fast(n.sample=5000,
                                  P=0.05,
                                  dist.X.loi = example.dist)
head(data.pps.fast)
}
