% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compcol.R
\name{compcol}
\alias{compcol}
\title{Two-species Competition-colonization Metapopulation Model}
\usage{
compcol(t, y, params)
}
\arguments{
\item{t}{Argument for time}

\item{y}{A vector for population 1 and 2}

\item{params}{Vector or list of parameters}
}
\value{
Returns a list of length one, for use with \code{ode} in the
\code{deSolve} package.  \item{Component 1 }{vector of the state variables,
y.}
}
\description{
This model implements a Levins-type metapopulation model for two species,
after Hastings (1980).  For use with \code{ode} in the \code{deSolve}
package.
}
\examples{

library(deSolve)
pars <- c(c1 = .3, c2 = 1, m1 = .1, m2 = .1)
pops <- c(.1,.1)
out <- ode(y=pops, t=0:20, fun=compcol, parms = pars)
matplot(out[,1], out[,-1], type='l')

}
\references{
Hastings, A. (1980) Disturbance, coexistence, history, and
competition for space. \emph{Theoretical Population Biology}, \bold{18},
363--373.

Stevens. M.H.H. (2009) \emph{A Primer of Ecology with R}. Use R! Series.
Springer.
}
\seealso{
\code{\link{levins}}, \code{\link{compcolM}},
\code{\link{succniche}}
}
\author{
Hank Stevens <HankStevens@miamioh.edu>
}
\keyword{methods}
