% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_cost}
\alias{simulate_cost}
\alias{simulate_cost.Raster}
\alias{simulate_cost.SpatRaster}
\title{Simulate cost data}
\usage{
simulate_cost(x, n, intensity, sd, scale)

\method{simulate_cost}{Raster}(x, n = 1, intensity = 100, sd = 20, scale = 2.5)

\method{simulate_cost}{SpatRaster}(x, n = 1, intensity = 100, sd = 20, scale = 2.5)
}
\arguments{
\item{x}{\code{\link[terra:rast]{terra::rast()}} object to use as a template.}

\item{n}{\code{integer} number of layers to simulate.
Defaults to 1.}

\item{intensity}{\code{numeric} average value of simulated data.
Defaults to 100.}

\item{sd}{\code{numeric} standard deviation of simulated data.
Defaults to 20.}

\item{scale}{\code{numeric} parameter to control level of spatial
auto-correlation in the simulated data.
Defaults to 2.5.}
}
\value{
A \code{\link[terra:rast]{terra::rast()}} object with integer values greater than zero.
}
\description{
Generates simulated cost data using Gaussian random fields.
}
\examples{
\dontrun{
# create raster
r <- terra::rast(
  ncols = 10, nrows = 10, xmin = 0, xmax = 1, ymin = 0, ymax = 1, vals = 1
)

# simulate data
cost <- simulate_cost(r)

# plot simulated species
plot(cost, main = "simulated cost data", axes = FALSE)
}

}
\seealso{
Other functions for simulating data:
\code{\link{simulate_data}()},
\code{\link{simulate_species}()}
}
\concept{simulations}
