% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordProf_UQ.R
\name{coordProf_UQ}
\alias{coordProf_UQ}
\title{Coordinate profiles UQ from a kriging model}
\usage{
coordProf_UQ(object, threshold, allResMean = NULL,
  quantiles_uq = c(0.05, 0.95), options_approx = NULL,
  options_full_sims = NULL, options_sims = NULL,
  options_bound = NULL, plot_level = 0, plot_options = NULL,
  return_level = 1)
}
\arguments{
\item{object}{either a \link[DiceKriging]{km} model or a list containing partial results. If \code{object} is a km model then all computations are carried out. If \code{object} is a list, then the function carries out all computations to complete the results list.}

\item{threshold}{the threshold of interest}

\item{allResMean}{a list resulting from \code{getAllMaxMin} or \code{approxMaxMin} for the profile extrema on the mean. If NULL the median from the observations is plotted}

\item{quantiles_uq}{a vector containing the quantiles to be computed}

\item{options_approx}{an optional list of options for approxMaxMin, see \link{approxMaxMin} for details.}

\item{options_full_sims}{an optional list of options for getAllMaxMin, see \link{getAllMaxMin} for details. If NULL the full computations are not excuted. NOTE: this computations might be very expensive!}

\item{options_sims}{an optional list of options for the posterior simulations.
\itemize{
\item{\code{algorithm:}} string choice of the algorithm to select the pilot points ("A" or "B", default "B");
\item{\code{lower:}} \eqn{d} dimensional vector with lower bounds for pilot points, default \code{rep(0,d)};
\item{\code{upper:}} \eqn{d} dimensional vector with upper bounds for pilot points, default \code{rep(1,d)};
\item{\code{batchsize:}} number of pilot points, default \code{120};
\item{\code{optimcontrol:}} list containing the options for optimization, see \link[pGPx]{optim_dist_measure};
\item{\code{integcontrol:}} list containing the options for numerical integration of the criterion, see \link[pGPx]{optim_dist_measure};
\item{\code{integration.param:}} list containing the integration design, obtained with the function \link[KrigInv]{integration_design};
\item{\code{nsim:}} number of approximate GP simulations, default \code{300}.
}}

\item{options_bound}{an optional list containing \code{beta} the confidence level for the approximation and \code{alpha} the confidence level for the bound. Note that \code{alpha > 2*beta}. If \code{NULL}, the bound is not computed.}

\item{plot_level}{an integer to select the plots to return (0=no plots, 1=basic plots, 2= all plots)}

\item{plot_options}{an optional list of parameters for plots. See \link{setPlotOptions} for currently available options.}

\item{return_level}{an integer to select the amount of details returned}
}
\value{
If return_level=1 a list containing \itemize{
\item{\code{profSups:}}{an array \code{dxfullDesignSizexnsims} containing the profile sup for each coordinate for each realization.}
\item{\code{profInfs:}}{an array \code{dxfullDesignSizexnsims} containing the profile inf for each coordinate for each realization.}
\item{\code{prof_quantiles_approx:}}{a list containing the quantiles (levels set by \code{quantiles_uq}) of the profile extrema functions.}
} if return_level=2 the same list as above but also including \code{more:} a list containing \itemize{
\item{\code{times:}}{a list containing
	\itemize{
	\item{\code{tSpts:} }{computational time for selecting pilot points.}
	\item{\code{tApprox1ord:}}{vector containing the computational time required for profile extrema computation for each realization}
	}}
\item{\code{simuls:}}{ a matrix containing the value of the field simulated at the pilot points}
\item{\code{sPts:}}{the pilot points}
}
}
\description{
The function coordProf_UQ computes the profile extrema functions for posterior realizations of a Gaussian process and its confidence bounds
}
\examples{
if (!requireNamespace("DiceKriging", quietly = TRUE)) {
stop("DiceKriging needed for this example to work. Please install it.",
     call. = FALSE)
}
# Compute a kriging model from 50 evaluations of the Branin function
# Define the function
g<-function(x){
  return(-branin(x))
}
gp_des<-lhs::maximinLHS(20,2)
reals<-apply(gp_des,1,g)
kmModel<-km(design = gp_des,response = reals,covtype = "matern3_2")

threshold=-10
d<-2

# Compute coordinate profiles UQ starting from GP model
# define simulation options
options_sims<-list(algorithm="B", lower=rep(0,d), upper=rep(1,d),
                   batchsize=80, optimcontrol = list(method="genoud",pop.size=100,print.level=0),
                   integcontrol = list(distrib="sobol",n.points=1000), nsim=150)
# define 1 order approximation options
init_des<-lhs::maximinLHS(15,d)
options_approx<- list(multistart=4,heavyReturn=TRUE,
                      initDesign=init_des,fullDesignSize=100,
                      smoother="1order")
# define plot options
options_plots<-list(save=FALSE, titleProf = "Coordinate profiles",
                    title2d = "Posterior mean",qq_fill=TRUE)
\dontrun{
# profile UQ on approximate coordinate profiles
cProfiles_UQ<-coordProf_UQ(object = kmModel,threshold = threshold,allResMean = NULL,
                            quantiles_uq = c(0.05,0.95),options_approx = options_approx,
                            options_full_sims = NULL,options_sims = options_sims,
                            options_bound = NULL,plot_level = 3,
                            plot_options = options_plots,return_level = 3)
# profile UQ on full optim coordinate profiles
options_full_sims<-list(multistart=4,heavyReturn=TRUE)
cProfiles_UQ_full<-coordProf_UQ(object = cProfiles_UQ,threshold = threshold,allResMean = NULL,
                            quantiles_uq = c(0.05,0.95),options_approx = options_approx,
                            options_full_sims = options_full_sims,options_sims = options_sims,
                            options_bound = NULL,plot_level = 3,
                            plot_options = options_plots,return_level = 3)

# profile UQ on full optim coordinate profiles with bound
cProfiles_UQ_full_bound<-coordProf_UQ(object = cProfiles_UQ_full,threshold = threshold,
                                      allResMean = NULL, quantiles_uq = c(0.05,0.95),
                                      options_approx = options_approx,
                                      options_full_sims = options_full_sims,
                                      options_sims = options_sims,
                                      options_bound = list(beta=0.024,alpha=0.05),
                                      plot_level = 3, plot_options = options_plots,
                                      return_level = 3)
}
}
\author{
Dario Azzimonti
}
