% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_univariate_profiles_UQ.R
\name{plot_univariate_profiles_UQ}
\alias{plot_univariate_profiles_UQ}
\title{Univariate profile extrema with UQ}
\usage{
plot_univariate_profiles_UQ(objectUQ, plot_options, nsims, threshold,
  nameFile = "prof_UQ", quantiles_uq = c(0.05, 0.95),
  profMean = NULL, typeProf = "approx")
}
\arguments{
\item{objectUQ}{an object returned by \link{coordProf_UQ} or the object saved in \code{obj$res_UQ}, if \code{obj} is the object returned by \link{coordinateProfiles}.}

\item{plot_options}{a list containing the same elements as the one passed to \link{coordinateProfiles}}

\item{nsims}{number of simulations}

\item{threshold}{threshold of interest}

\item{nameFile}{the central name of the plot file}

\item{quantiles_uq}{a vector containing the quantiles to be computed}

\item{profMean}{the profile coordinate extrema functions for the mean. It is saved in \code{obj$profMean_full} or \code{obj$profMean_approx} if \code{obj} is an object returned by \link{coordinateProfiles}.}

\item{typeProf}{a string to choose with type of profile extrema for simulations to plot \itemize{
\item{"approx"}{plots only the approximate profile extrema for simulations}
\item{"full"}{plots only the full profile extrema for simulations}
\item{"both"}{plots both the approximate and full profile extrema for simulations}
}}
}
\value{
Plots either to the default graphical device or to pdf (according to the options passed in \code{plot_options})
}
\description{
Function to plot the univariate profile extrema functions with UQ
}
