% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileCI-methods.R
\name{profileCI_methods}
\alias{profileCI_methods}
\alias{print.profileCI}
\alias{plot.profileCI}
\title{Methods for objects of class \code{"profileCI"}}
\usage{
\method{print}{profileCI}(x, ...)

\method{plot}{profileCI}(x, parm = 1:nrow(x), add = TRUE, digits = 2, ...)
}
\arguments{
\item{x}{An object inheriting from class \verb{profileCI"}, a result of a call
to \code{\link{profileCI}}.}

\item{...}{Further arguments. For \verb{print."profileCI"} to pass arguments to
\code{\link{print}}. For \code{plot.profileCI} to pass graphical parameters to
\code{\link[graphics:plot.default]{graphics::plot}} to create the initial plot of the profile
log-likelihood.}

\item{parm}{A numeric or character scalar specifying the parameter for which
a profile log-likelihood is plotted. Must be a single component consistent
with the argument \code{parm} to \code{\link{profileCI}}.}

\item{add}{A logical scalar. If \code{add = TRUE} then the plot is annotated with
a horizontal line indicating the critical value for the profile
log-likelihood used to calculate the confidence limits, vertical lines
indicating the values of these limits and a legend stating the
confidence interval.}

\item{digits}{An integer. Passed to \code{\link{signif}} to round the confidence
limits in the legend, if \code{add = TRUE}. The confidence level is hard-coded
to be expressed to 3 significant figures.}
}
\value{
\code{print.profileCI}: the argument \code{x} is returned, invisibly.

\code{plot.profileCI}: a numeric vector containing the confidence interval
for the parameter chosen for the plot.
}
\description{
Methods for objects of class \code{"profileCI"} returned from \code{\link{profileCI}}.
}
\details{
\code{print.profileCI}. A numeric matrix with 2 columns giving the
lower and upper confidence limits for the parameters specified by the
argument \code{parm} in \code{\link{profileCI}}. These columns are labelled as
\code{(1-level)/2} and \code{1-(1-level)/2}, expressed as a percentage, by default
\verb{2.5\%} and \verb{97.5\%}.

\code{plot.profileCI}. A plot is produced of the profile log-likelihood for
the parameter chosen by \code{parm}. Only the parameter values used to profile
the log-likelihood in the call to \code{\link{profileCI}} are included, so
if \code{faster = TRUE} was used then the plot will not be of a smooth curve
but will be triangular in the middle.
}
\section{Examples}{
 See \code{\link{profileCI}}.
}

\seealso{
\code{\link{profileCI}}.
}
