% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_data.R
\name{clean_data}
\alias{clean_data}
\title{Clean Data by Interpolating Missing Values}
\usage{
clean_data(data, n_trials, n_replicates)
}
\arguments{
\item{data}{A data frame containing the dataset to be cleaned.}

\item{n_trials}{The total number of rows in the dataset.}

\item{n_replicates}{The total number of replicate columns in each row.}
}
\value{
A cleaned data frame with missing values interpolated.
}
\description{
Clean Data by Interpolating Missing Values
}
\details{
This function cleans a dataset by interpolating missing values in the replicate
columns of each row using neighboring values. If the data frame ends in null values
(the last columns are nulls), it will extrapolate from the last value. If the
first value is null, it will loop around and pull from the last replicate to
perform the interpolation between the last replicate and the second replicate.
}
\examples{
my_data <- matrix(
   c(
     1, 60, 1, 2, 3, 4, 5,   # No NA values
     1, 90, 9, NA, 4, NA, 2,  # NA Values in row
     1, 120, 3, 6, NA, NA, 9  # Consecutive NA values
    ),
    nrow = 3,
    byrow=TRUE
 )
cleaned_data <- clean_data(my_data, n_trials = 3, n_replicates = 5)
print(my_data)
print(cleaned_data)

}
\seealso{
\code{\link{find_next_good_datapoint}} for details on the interpolation process.
}
